/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIRelationsAddedList;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIRelationsAddedList.msg.confirm-delete")})
public class UIRelationsAddedList
extends UIContainer
implements UISelectable {
    private static String[] RELATE_BEAN_FIELD = new String[]{"path"};
    private static String[] ACTION = new String[]{"Delete"};

    public UIRelationsAddedList() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, "RelateAddedList");
        uiGrid.setDisplayedChars(150);
        uiGrid.getUIPageIterator().setId("RelateListIterator");
        uiGrid.configure("path", RELATE_BEAN_FIELD, ACTION);
    }

    public void updateGrid(List<Node> nodes) throws Exception {
        UIGrid uiGrid = (UIGrid)this.getChildById("RelateAddedList");
        if (nodes == null) {
            nodes = new ArrayList<Node>();
        }
        ObjectPageList objPageList = new ObjectPageList(nodes, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        RelationsService relateService = (RelationsService)this.getApplicationComponent(RelationsService.class);
        String currentFullPath = uiJCRExplorer.getCurrentWorkspace() + ":" + uiJCRExplorer.getCurrentNode().getPath();
        if (value.equals(currentFullPath)) {
            throw new MessageException(new ApplicationMessage("UIRelationsAddedList.msg.can-not-add-itself", null, 1));
        }
        try {
            String lockToken;
            String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            String wsName = value.toString().substring(0, value.toString().indexOf(":"));
            String path = value.toString().substring(value.toString().indexOf(":") + 1);
            if (uiJCRExplorer.getCurrentNode().isLocked() && (lockToken = LockUtil.getLockToken((Node)uiJCRExplorer.getCurrentNode())) != null) {
                uiJCRExplorer.getSession().addLockToken(lockToken);
            }
            relateService.addRelation(uiJCRExplorer.getCurrentNode(), path, wsName, repository);
            this.updateGrid(relateService.getRelations(uiJCRExplorer.getCurrentNode(), uiJCRExplorer.getRepositoryName(), SessionProviderFactory.createSessionProvider()));
            this.setRenderSibbling(UIRelationsAddedList.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

