/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.jcr.model;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNode {
    private boolean isExpanded = true;
    private Version version_;
    private List<VersionNode> children_ = new ArrayList();

    public VersionNode(Version version, Session session) {
        this.version_ = version;
        try {
            String uuid = version.getUUID();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("//element(*, nt:version)[@jcr:predecessors='" + uuid + "']", "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator iterate = queryResult.getNodes();
            while (iterate.hasNext()) {
                Version version1 = (Version)iterate.nextNode();
                this.children_.add(new VersionNode(version1, session));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public Version getVersion() {
        return this.version_;
    }

    public void setVersion(Version version) {
        this.version_ = version;
    }

    public String getName() throws RepositoryException {
        return this.version_.getName();
    }

    public String getPath() throws RepositoryException {
        return this.version_.getPath();
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public List<VersionNode> getChildren() {
        return this.children_;
    }

    public VersionNode findVersionNode(String path) throws RepositoryException {
        if (this.version_.getPath().equals(path)) {
            return this;
        }
        VersionNode node = null;
        for (VersionNode child : this.children_) {
            node = child.findVersionNode(path);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void removeVersionInChild(VersionNode versionNode1, VersionNode versionNodeRemove) throws RepositoryException {
        if (versionNode1.getChildren().contains(versionNodeRemove)) {
            versionNode1.getChildren().remove(versionNodeRemove);
        } else {
            for (VersionNode vsN : versionNode1.getChildren()) {
                this.removeVersionInChild(vsN, versionNodeRemove);
            }
        }
    }
}

