/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UIDocumentForm
extends UIDialogForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_TAXONOMY = "categories";
    public static final String POPUP_TAXONOMY = "PopupComponent";
    public static final String PATH_TAXONOMY = "exoTaxonomiesPath";
    private List<String> listTaxonomy = new ArrayList();
    private List<String> listTaxonomyName = new ArrayList();

    public UIDocumentForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomy(List<String> listTaxonomyNew) {
        this.listTaxonomy = listTaxonomyNew;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        Session session = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getSession();
        return ((Node)session.getItem(nodeHierarchyCreator.getJcrPath(PATH_TAXONOMY))).getPath();
    }

    public void initFieldInput() throws Exception {
        UIJCRExplorer uiExplorer;
        Node currentNode;
        CategoriesService categoriesService = (CategoriesService)this.getApplicationComponent(CategoriesService.class);
        if (categoriesService.hasCategories(currentNode = (uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode())) {
            Value[] values = currentNode.getProperty("exo:category").getValues();
            for (int i = 0; i < values.length; ++i) {
                String path = uiExplorer.getSession().getNodeByUUID(values[i].getString()).getPath();
                if (this.listTaxonomy.contains(path)) continue;
                this.listTaxonomy.add(path);
                this.listTaxonomyName.add(this.cutPath(path));
            }
        }
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiFormMultiValue.setId(FIELD_TAXONOMY);
        uiFormMultiValue.setName(FIELD_TAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setValue(this.listTaxonomyName);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    private String cutPath(String path) throws Exception {
        String pathTaxonomy = this.getPathTaxonomy() + "/";
        String returnString = path.replaceAll(pathTaxonomy, "");
        return returnString;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            String valueTaxonomy = String.valueOf(value).trim();
            List taxonomylist = inputSet.getValue();
            if (!taxonomylist.contains(valueTaxonomy)) {
                this.listTaxonomy.add(valueTaxonomy);
                this.listTaxonomyName.add(this.cutPath(valueTaxonomy));
                taxonomylist.add(this.cutPath(valueTaxonomy));
            }
            inputSet.setValue(taxonomylist);
        }
        UIDocumentFormController uiContainer = (UIDocumentFormController)this.getParent();
        uiContainer.removeChildById(POPUP_TAXONOMY);
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName, this.repositoryName);
        }
        catch (Exception e) {
            e.printStackTrace();
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    static /* synthetic */ boolean access$000(UIDocumentForm x0) {
        return x0.isReference;
    }

    static /* synthetic */ String access$100(UIDocumentForm x0) {
        return x0.repositoryName;
    }

    static /* synthetic */ boolean access$202(UIDocumentForm x0, boolean x1) {
        x0.isShowingComponent = x1;
        return x0.isShowingComponent;
    }

    static /* synthetic */ Map access$300(UIDocumentForm x0) {
        return x0.componentSelectors;
    }

    static /* synthetic */ boolean access$402(UIDocumentForm x0, boolean x1) {
        x0.isRemovePreference = x1;
        return x0.isRemovePreference;
    }

    static /* synthetic */ boolean access$500(UIDocumentForm x0) {
        return x0.isReference;
    }
}

