/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.query.Query;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.search.UIJCRAdvancedSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISavedQuery;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISavedQuery.gtmpl", events={@EventConfig(listeners={ExecuteActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UISavedQuery.msg.confirm-delete-query"), @EventConfig(listeners={EditActionListener.class})})
public class UISavedQuery
extends UIContainer
implements UIPopupComponent {
    public static final String EDIT_FORM = "EditSavedQueryForm";
    private UIPageIterator uiPageIterator_;
    private List<Node> sharedQueries_ = new ArrayList();
    private List<Query> privateQueries = new ArrayList();
    private boolean isQuickSearch_ = false;
    private String repositoryName_;

    public UISavedQuery() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "SavedQueryIterator");
    }

    public void updateGrid() throws Exception {
        ObjectPageList pageList = new ObjectPageList(this.queryList(), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
    }

    public List<Object> queryList() throws Exception {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (this.hasSharedQueries()) {
            for (Node node : this.getSharedQueries()) {
                objectList.add(node);
            }
        }
        if (this.hasQueries()) {
            for (Query query : this.getQueries()) {
                objectList.add(query);
            }
        }
        return objectList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getQueryList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void initPopupEditForm(Query query) throws Exception {
        this.removeChildById(EDIT_FORM);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, EDIT_FORM);
        uiPopup.setWindowSize(500, 0);
        UIJCRAdvancedSearch uiJAdvancedSearch = (UIJCRAdvancedSearch)this.createUIComponent(UIJCRAdvancedSearch.class, null, "EditQueryForm");
        uiJAdvancedSearch.setActions(new String[]{"Save", "Cancel"});
        uiPopup.setUIComponent((UIComponent)uiJAdvancedSearch);
        uiPopup.setRendered(true);
        uiJAdvancedSearch.setIsEdit(true);
        uiJAdvancedSearch.setQuery(query);
        uiJAdvancedSearch.update(query);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public boolean hasQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        try {
            this.privateQueries = queryService.getQueries(this.getCurrentUserId(), this.repositoryName_, SessionProviderFactory.createSessionProvider());
            return !this.privateQueries.isEmpty();
        }
        catch (AccessDeniedException ace) {
            return this.privateQueries.isEmpty();
        }
    }

    public List<Query> getQueries() throws Exception {
        return this.privateQueries;
    }

    public String getCurrentUserId() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public boolean hasSharedQueries() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String userId = pcontext.getRemoteUser();
        SessionProvider provider = SessionProviderFactory.createSystemProvider();
        this.sharedQueries_ = queryService.getSharedQueries(userId, this.repositoryName_, provider);
        return !this.sharedQueries_.isEmpty();
    }

    public List<Node> getSharedQueries() {
        return this.sharedQueries_;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setIsQuickSearch(boolean isQuickSearch) {
        this.isQuickSearch_ = isQuickSearch;
    }

    static /* synthetic */ boolean access$000(UISavedQuery x0) {
        return x0.isQuickSearch_;
    }

    static /* synthetic */ String access$100(UISavedQuery x0) {
        return x0.repositoryName_;
    }
}

