/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String WORKSPACE_NAME = "workspace".intern();
    public static final String JCR_PATH = "path".intern();
    public static final String DRIVE_FOLDER = "allowCreateFolder".intern();
    public static final String MIN_WIDTH = "minwidth".intern();
    public static final String CB_DOCUMENT_NAME = "documentName".intern();
    public static final String CB_SCRIPT_NAME = "scriptName".intern();
    public static final String CB_REF_DOCUMENT = "reference".intern();
    public static final String CB_CHILD_DOCUMENT = "child".intern();
    public static final String CB_NB_PER_PAGE = "nbPerPage".intern();
    public static final String CB_QUERY_STATEMENT = "queryStatement".intern();
    public static final String CB_QUERY_ISNEW = "isAddNew".intern();
    public static final String CB_QUERY_TYPE = "queryType".intern();
    public static final String CB_QUERY_STORE = "queryStore".intern();
    public static final String CB_QUERY_LANGUAGE = "queryLanguage".intern();
    public static final String CB_VIEW_TOOLBAR = "viewToolbar".intern();
    public static final String CB_VIEW_TAGMAP = "viewTagMap".intern();
    public static final String CB_VIEW_COMMENT = "viewComment".intern();
    public static final String CB_VIEW_VOTE = "viewVote".intern();
    public static final String CB_BOX_TEMPLATE = "boxTemplate".intern();
    public static final String CB_TEMPLATE = "template";
    public static final String CB_USECASE = "usecase".intern();
    public static final String FROM_PATH = "From Path".intern();
    public static final String USE_DOCUMENT = "Document".intern();
    public static final String USE_JCR_QUERY = "Using a JCR query".intern();
    public static final String USE_SCRIPT = "Using a script".intern();
    public static final String CB_USE_FROM_PATH = "path".intern();
    public static final String CB_USE_DOCUMENT = "detail-document".intern();
    public static final String CB_USE_JCR_QUERY = "query".intern();
    public static final String CB_USE_SCRIPT = "script".intern();
    public static final String SEMI_COLON = ";".intern();
    public static final String COLON = ":".intern();
    public static final String SLASH = "/".intern();
    public static final String BACKSLASH = "\\".intern();
    public static final String EXO_CREATED_DATE = "exo:dateCreated";
    public static final String EXO_MODIFIED_DATE = "exo:dateModified";
    public static final String[] SPECIALCHARACTER = new String[]{SEMI_COLON, COLON, SLASH, BACKSLASH, "'", "|", ">", "<", "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*"};
    public static final String REPOSITORY = "repository".intern();
    public static final String VIEWS = "views".intern();
    public static final String DRIVE = "drive".intern();
    public static final String JCR_INFO = "jcrInfo";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FROZEN = "nt:frozenNode".intern();
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_RELATION = "exo:relation";
    public static final String EXO_TAXANOMY = "exo:taxonomy";
    public static final String EXO_IMAGE = "exo:image";
    public static final String EXO_ARTICLE = "exo:article";
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String LANGUAGES = "languages";
    public static final String EXO_METADATA = "exo:metadata";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String DEFAULT = "default";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_FROZEN = "jcr:frozenNode";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_DATA = "jcr:data";
    public static final String EXO_ROLES = "exo:roles";
    public static final String EXO_TEMPLATEFILE = "exo:templateFile";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ACTION = "exo:action";
    public static final String MIX_LOCKABLE = "mix:lockable";
    public static final String EXO_CATEGORIZED = "exo:categorized";
    public static final String EXO_CATEGORY = "exo:category";
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String RMA_RECORD = "rma:record";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};
    public static final String[] FOLDERS = new String[]{"nt:unstructured", "nt:folder"};
    public static final String[] NON_EDITABLE_NODETYPES = new String[]{"nt:unstructured", "nt:folder", "nt:resource"};
    public static final String[] CATEGORY_NODE_TYPES = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
    public Map<String, Object> maps_ = new HashMap();

    public static String encodeHTML(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String formatNodeName(String text) {
        return text.replaceAll("'", "\\\\'");
    }

    public static boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    public static boolean isReadAuthorized(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("read");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isAddNodeAuthorized(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("add_node");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isChangePermissionAuthorized(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("add_node,set_property,remove");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean hasChangePermissionRight(Node node) throws RepositoryException {
        return Utils.isAddNodeAuthorized((Node)node) && Utils.isSetPropertyNodeAuthorized((Node)node) && Utils.isRemoveNodeAuthorized((Node)node);
    }

    public static boolean isAnyPermissionAuthorized(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(SystemIdentity.ANY);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isSetPropertyNodeAuthorized(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("set_property");
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public static boolean isRemoveNodeAuthorized(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("remove");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isNodeAuthorized(Node node, String owner) throws Exception {
        return ((ExtendedNode)node).getACL().getOwner().equals(owner);
    }

    public static boolean isNameValid(String name, String[] regexpression) {
        for (String c : regexpression) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameEmpty(String name) {
        return name == null || name.trim().length() == 0;
    }

    public static List<String> getListAllowedFileType(Node currentNode, String repository, TemplateService templateService) throws Exception {
        ArrayList<String> nodeTypes = new ArrayList<String>();
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        NodeType currentNodeType = currentNode.getPrimaryNodeType();
        NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
        List templates = templateService.getDocumentTemplates(repository);
        try {
            block2: for (int i = 0; i < templates.size(); ++i) {
                String nodeTypeName = templates.get(i).toString();
                NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                NodeType[] superTypes = nodeType.getSupertypes();
                boolean isCanCreateDocument = false;
                for (NodeDefinition nodeDefinition : childDefs) {
                    NodeType[] requiredChilds;
                    for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                        if (!nodeTypeName.equals(requiredChild.getName())) continue;
                        isCanCreateDocument = true;
                        break;
                    }
                    if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                    if (!nodeTypes.contains(nodeTypeName)) {
                        nodeTypes.add(nodeTypeName);
                    }
                    isCanCreateDocument = true;
                }
                if (isCanCreateDocument) continue;
                for (NodeDefinition nodeDefinition : superTypes) {
                    for (NodeDefinition childDef : childDefs) {
                        for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                            if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                            if (!nodeTypes.contains(nodeTypeName)) {
                                nodeTypes.add(nodeTypeName);
                            }
                            isCanCreateDocument = true;
                            break;
                        }
                        if (isCanCreateDocument) break;
                    }
                    if (isCanCreateDocument) continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodeTypes;
    }

    public static String getNodeTypeIcon(Node node, String appended, String mode) throws RepositoryException {
        StringBuilder str = new StringBuilder();
        String nodeType = node.getPrimaryNodeType().getName();
        if (nodeType.equals("nt:unstructured") || nodeType.equals("nt:folder")) {
            for (String specificFolder : SPECIFIC_FOLDERS) {
                if (!node.isNodeType(specificFolder)) continue;
                nodeType = specificFolder;
                break;
            }
        }
        nodeType = nodeType.replaceAll(":", "_") + appended;
        str.append(nodeType);
        if (mode != null && mode.equalsIgnoreCase("Collapse")) {
            str.append(" ").append(mode).append(nodeType);
        }
        if (node.isNodeType("nt:file")) {
            Node jcrContentNode = node.getNode("jcr:content");
            str.append(" ").append(jcrContentNode.getProperty("jcr:mimeType").getString().replaceAll("/|\\.", "_")).append(appended);
        }
        return str.toString();
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        return Utils.getNodeTypeIcon((Node)node, (String)appended, null);
    }

    public String getPropertyName(String jcrPath) {
        return jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
    }

    public static NodeIterator getAuthorizedChildNodes(Node node) throws Exception {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            if (Utils.isReadAuthorized((Node)iter.nextNode())) continue;
            iter.remove();
        }
        return iter;
    }

    public static List<Node> getAuthorizedChildList(Node node) throws Exception {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!Utils.isReadAuthorized((Node)child)) continue;
            children.add(child);
        }
        return children;
    }

    public static boolean isLockTokenHolder(Node node) throws Exception {
        return node.getLock().getLockToken() != null;
    }

    public static String getRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(REPOSITORY, "");
    }

    public static Map prepareMap(List inputs, Map properties) throws Exception {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                String inputName = ((UIFormMultiValueInputSet)inputs.get(i)).getName();
                if (!hasMap.containsKey(inputName)) {
                    List values = ((UIFormMultiValueInputSet)inputs.get(i)).getValue();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (property != null) {
                        property.setValue((Object)values.toArray(new String[values.size()]));
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (property == null) continue;
            if (input instanceof UIFormUploadInput) {
                byte[] content = ((UIFormUploadInput)input).getUploadData();
                property.setValue((Object)content);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        return rawinputs;
    }

    public static Map prepareMap(List inputs, Map properties, Session session) throws Exception {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                String inputName = ((UIFormMultiValueInputSet)inputs.get(i)).getName();
                if (!hasMap.containsKey(inputName)) {
                    List values = ((UIFormMultiValueInputSet)inputs.get(i)).getValue();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (property != null) {
                        property.setValue((Object)values.toArray(new String[values.size()]));
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (property == null) continue;
            if (input instanceof UIFormUploadInput) {
                byte[] content = ((UIFormUploadInput)input).getUploadData();
                property.setValue((Object)content);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        return rawinputs;
    }

    public static List<String> getMemberships() throws Exception {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService oservice = (OrganizationService)Util.getUIPortal().getApplicationComponent(OrganizationService.class);
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection memberships = oservice.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Membership membership = (Membership)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroupId();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    public static List<String> getGroups() throws Exception {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService oservice = (OrganizationService)Util.getUIPortal().getApplicationComponent(OrganizationService.class);
        ArrayList<String> groupList = new ArrayList<String>();
        Collection groups = oservice.getGroupHandler().findGroupsOfUser(userId);
        Object[] objects = groups.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Group group = (Group)objects[i];
            String groupPath = null;
            groupPath = group.getParentId() == null || group.getParentId().length() == 0 ? "/" + group.getGroupName() : group.getParentId() + "/" + group.getGroupName();
            groupList.add(groupPath);
        }
        return groupList;
    }

    public static String getNodeOwner(Node node) throws Exception {
        try {
            if (node.hasProperty("exo:owner")) {
                return node.getProperty("exo:owner").getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ByteArrayInputStream extractFromZipFile(ZipInputStream zipStream) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            int available = -1;
            while ((available = zipStream.read(data, 0, 1024)) > -1) {
                out.write(data, 0, available);
            }
            zipStream.closeEntry();
            entry = zipStream.getNextEntry();
        }
        out.close();
        zipStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        return inputStream;
    }
}

