/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/UIFormInputSetWithAction.gtmpl")
public class UIPropertyDefinitionForm
extends UIFormInputSetWithAction {
    public static final String NAMESPACE = "propertyNamespace";
    public static final String DEFINITION_NAME = "propertyname";
    public static final String REQUIRED_TYPE = "requiredType";
    public static final String MULTIPLE = "multiple";
    public static final String MANDATORY = "mandatory";
    public static final String AUTOCREATED = "autoCreated";
    public static final String PROTECTED = "protected";
    public static final String PARENTVERSION = "parentversion";
    public static final String CONSTRAINTS = "constraints";
    public static final String VALUE_CONSTRAINTS = "valueconstraints";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ACTION_UPDATE_PROPERTY = "UpdateProperty";
    public static final String ACTION_CANCEL_PROPERTY = "CancelProperty";
    private String requiredValue_;

    public UIPropertyDefinitionForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> multiListItem = new ArrayList<SelectItemOption>();
        multiListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        multiListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NAMESPACE, NAMESPACE, this.getNamespaces()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DEFINITION_NAME, DEFINITION_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormSelectBox uiRequired = new UIFormSelectBox(REQUIRED_TYPE, REQUIRED_TYPE, this.getRequiredTypes());
        uiRequired.setOnChange("ChangeRequiredType");
        this.addUIFormInput((UIFormInput)uiRequired);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(AUTOCREATED, AUTOCREATED, autoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MANDATORY, MANDATORY, mandoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PARENTVERSION, PARENTVERSION, this.getParentVersions()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PROTECTED, PROTECTED, protectedItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MULTIPLE, MULTIPLE, multiListItem));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(VALUE_CONSTRAINTS, VALUE_CONSTRAINTS, null));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private List<SelectItemOption<String>> getParentVersions() {
        ArrayList<SelectItemOption<String>> versionItem = new ArrayList<SelectItemOption<String>>();
        versionItem.add(new SelectItemOption("COPY", (Object)"1"));
        versionItem.add(new SelectItemOption("VERSION", (Object)"2"));
        versionItem.add(new SelectItemOption("INITIALIZE", (Object)"3"));
        versionItem.add(new SelectItemOption("COMPUTE", (Object)"4"));
        versionItem.add(new SelectItemOption("IGNORE", (Object)"5"));
        versionItem.add(new SelectItemOption("ABORT", (Object)"6"));
        return versionItem;
    }

    private List<SelectItemOption<String>> getRequiredTypes() {
        ArrayList<SelectItemOption<String>> requireType = new ArrayList<SelectItemOption<String>>();
        requireType.add(new SelectItemOption("STRING", (Object)"1"));
        requireType.add(new SelectItemOption("BINARY", (Object)"2"));
        requireType.add(new SelectItemOption("LONG", (Object)"3"));
        requireType.add(new SelectItemOption("DOUBLE", (Object)"4"));
        requireType.add(new SelectItemOption("DATE", (Object)"5"));
        requireType.add(new SelectItemOption("BOOLEAN", (Object)"6"));
        requireType.add(new SelectItemOption("NAME", (Object)"7"));
        requireType.add(new SelectItemOption("PATH", (Object)"8"));
        requireType.add(new SelectItemOption("REFERENCE", (Object)"9"));
        requireType.add(new SelectItemOption("UNDEFINED", (Object)"0"));
        return requireType;
    }

    public List<SelectItemOption<String>> getNamespaces() throws Exception {
        ArrayList<SelectItemOption<String>> namespacesOptions = new ArrayList<SelectItemOption<String>>();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        String[] namespaces = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < namespaces.length; ++i) {
            namespacesOptions.add((SelectItemOption<String>)new SelectItemOption(namespaces[i], (Object)namespaces[i]));
        }
        return namespacesOptions;
    }

    public void refresh() throws Exception {
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> multiListItem = new ArrayList<SelectItemOption>();
        multiListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        multiListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.getUIFormSelectBox(NAMESPACE).setOptions(this.getNamespaces()).setDisabled(false);
        this.getUIStringInput(DEFINITION_NAME).setEditable(true).setValue(null);
        this.getUIFormSelectBox(REQUIRED_TYPE).setOptions(this.getRequiredTypes()).setDisabled(false);
        this.getUIFormSelectBox(AUTOCREATED).setOptions(autoListItem).setDisabled(false);
        this.getUIFormSelectBox(MANDATORY).setOptions(mandoListItem).setDisabled(false);
        this.getUIFormSelectBox(PARENTVERSION).setOptions(this.getParentVersions()).setDisabled(false);
        this.getUIFormSelectBox(PROTECTED).setOptions(protectedItem).setDisabled(false);
        this.getUIFormSelectBox(MULTIPLE).setOptions(multiListItem).setDisabled(false);
        this.getUIStringInput(VALUE_CONSTRAINTS).setEditable(true).setValue(null);
        UINodeTypeForm uiForm = (UINodeTypeForm)this.getParent();
        UIFormInputSetWithAction uiPropertyTab = (UIFormInputSetWithAction)uiForm.getChildById("propertyDefinition");
        uiForm.setActionInTab(uiPropertyTab);
    }

    private void setRequiredValue(String requiredValue) {
        this.requiredValue_ = requiredValue;
    }

    private String getRequiredValue() {
        return this.requiredValue_ == null ? "1" : this.requiredValue_;
    }

    public void update(NodeType nodeType, String propertyName) throws Exception {
        if (propertyName != null) {
            PropertyDefinition[] propertyDefinitions = nodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefinitions.length; ++i) {
                String name = propertyDefinitions[i].getName();
                if (!name.equals(propertyName)) continue;
                if (propertyName.indexOf(":") > -1) {
                    this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName.substring(propertyName.indexOf(":") + 1));
                    this.getUIFormSelectBox(NAMESPACE).setValue(propertyName.substring(0, propertyName.indexOf(":")));
                } else {
                    this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName);
                    this.getUIFormSelectBox(NAMESPACE).setValue("");
                }
                String requiredType = Integer.toString(propertyDefinitions[i].getRequiredType());
                this.getUIFormSelectBox(REQUIRED_TYPE).setValue(requiredType);
                this.getUIFormSelectBox(MULTIPLE).setValue(String.valueOf(propertyDefinitions[i].isMultiple()));
                this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(propertyDefinitions[i].isMandatory()));
                this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(propertyDefinitions[i].isAutoCreated()));
                this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(propertyDefinitions[i].isProtected()));
                String[] cons = propertyDefinitions[i].getValueConstraints();
                StringBuilder conValues = new StringBuilder();
                if (cons != null && cons.length > 0) {
                    for (int j = 0; j < cons.length; ++j) {
                        if (conValues.length() > 0) {
                            conValues.append(", ");
                        }
                        conValues.append(cons[j]);
                    }
                }
                this.getUIStringInput(VALUE_CONSTRAINTS).setValue((Object)conValues.toString());
                String parentVersion = Integer.toString(propertyDefinitions[i].getOnParentVersion());
                this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
                break;
            }
        }
        this.getUIFormSelectBox(NAMESPACE).setDisabled(true);
        this.getUIStringInput(DEFINITION_NAME).setEditable(false);
        this.getUIFormSelectBox(REQUIRED_TYPE).setDisabled(true);
        this.getUIFormSelectBox(AUTOCREATED).setDisabled(true);
        this.getUIFormSelectBox(MANDATORY).setDisabled(true);
        this.getUIFormSelectBox(PARENTVERSION).setDisabled(true);
        this.getUIFormSelectBox(PROTECTED).setDisabled(true);
        this.getUIFormSelectBox(MULTIPLE).setDisabled(true);
        this.getUIStringInput(VALUE_CONSTRAINTS).setEditable(false);
    }

    private PropertyDefinitionValue getPropertyByName(String propertyName, List<PropertyDefinitionValue> listProperty) {
        for (PropertyDefinitionValue property : listProperty) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    private void setValues(PropertyDefinitionValue property) throws Exception {
        String propertyName = property.getName();
        if (propertyName.indexOf(":") > -1) {
            this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName.substring(propertyName.indexOf(":") + 1));
            this.getUIFormSelectBox(NAMESPACE).setValue(propertyName.substring(0, propertyName.indexOf(":")));
        } else {
            this.getUIStringInput(DEFINITION_NAME).setValue((Object)propertyName);
            this.getUIFormSelectBox(NAMESPACE).setValue("");
        }
        String requiredType = Integer.toString(property.getRequiredType());
        this.getUIFormSelectBox(REQUIRED_TYPE).setValue(requiredType);
        this.getUIFormSelectBox(MULTIPLE).setValue(String.valueOf(property.isMultiple()));
        this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(property.isMandatory()));
        this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(property.isAutoCreate()));
        this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(property.isReadOnly()));
        List cons = property.getValueConstraints();
        String valueConstraints = null;
        for (String value : cons) {
            if (valueConstraints == null) {
                valueConstraints = value;
                continue;
            }
            valueConstraints = valueConstraints + "," + value;
        }
        this.getUIStringInput(VALUE_CONSTRAINTS).setValue(valueConstraints);
        String parentVersion = Integer.toString(property.getOnVersion());
        this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
    }

    static /* synthetic */ PropertyDefinitionValue access$000(UIPropertyDefinitionForm x0, String x1, List x2) {
        return x0.getPropertyByName(x1, x2);
    }

    static /* synthetic */ void access$100(UIPropertyDefinitionForm x0, PropertyDefinitionValue x1) throws Exception {
        x0.setValues(x1);
    }

    static /* synthetic */ void access$200(UIPropertyDefinitionForm x0, String x1) {
        x0.setRequiredValue(x1);
    }

    static /* synthetic */ String access$300(UIPropertyDefinitionForm x0) {
        return x0.getRequiredValue();
    }
}

