/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIPopupAction;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UICBScripts
extends UIContainer {
    public static String SCRIPTLIST_NAME = "CBScriptList";
    public static String SCRIPTFORM_NAME = "CBScriptForm";
    public static String SCRIPT_PAGE = "PageIterator";

    public UICBScripts() throws Exception {
        UIScriptList list = (UIScriptList)this.addChild(UIScriptList.class, null, SCRIPTLIST_NAME);
        list.getUIPageIterator().setId(SCRIPTLIST_NAME + SCRIPT_PAGE);
        UIPopupAction uiPopupAction = (UIPopupAction)this.addChild(UIPopupAction.class, null, "BCScriptPopupAction");
        ((UIPopupWindow)uiPopupAction.getChild(UIPopupWindow.class)).setId("BCScriptPopupWindow");
    }

    public void refresh() throws Exception {
        UIScriptList uiScriptList = (UIScriptList)this.getChildById(SCRIPTLIST_NAME);
        uiScriptList.updateGrid(this.getCBScript());
    }

    public List<UIScriptList.ScriptData> getCBScript() throws Exception {
        ArrayList<UIScriptList.ScriptData> scriptData = new ArrayList<UIScriptList.ScriptData>();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node cbScripts = scriptService.getCBScriptHome(repository, SessionsUtils.getSystemProvider());
        NodeIterator nodeList = cbScripts.getNodes();
        while (nodeList.hasNext()) {
            Node node = nodeList.nextNode();
            String version = "";
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            UIScriptList.ScriptData script = new UIScriptList.ScriptData(node.getName(), node.getPath(), version);
            scriptData.add(script);
        }
        return scriptData;
    }
}

