/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTree;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyWorkingArea;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UITaxonomyManager
extends UIContainer {
    private static String TAXONIMIES_ALIAS = "exoTaxonomiesPath";

    public UITaxonomyManager() throws Exception {
        this.addChild(UITaxonomyTree.class, null, null);
        this.addChild(UITaxonomyWorkingArea.class, null, null);
    }

    public void update() throws Exception {
        UITaxonomyTree uiTree = (UITaxonomyTree)this.getChild(UITaxonomyTree.class);
        uiTree.update();
    }

    public void update(String parentPath) throws Exception {
        UITaxonomyTree uiTree = (UITaxonomyTree)this.getChild(UITaxonomyTree.class);
        uiTree.setNodeSelect(parentPath);
        UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)this.getChild(UITaxonomyWorkingArea.class);
        uiWorkingArea.setSelectedPath(parentPath);
        uiWorkingArea.update();
    }

    public Node getRootNode() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return (Node)this.getSession().getItem(nodeHierarchyCreator.getJcrPath(TAXONIMIES_ALIAS));
    }

    public Node getNodeByPath(String path) throws Exception {
        return (Node)this.getSession().getItem(path);
    }

    public String getRepository() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        String repository = pref.getValue(Utils.REPOSITORY, "");
        return repository;
    }

    public Session getSession() throws Exception {
        String repositoryName = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        String workspace = this.getRepository(repositoryName).getConfiguration().getSystemWorkspaceName();
        return SessionsUtils.getSystemProvider().getSession(workspace, this.getRepository(repositoryName));
    }

    public ManageableRepository getRepository(String repositoryName) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(repositoryName);
    }

    public void initPopup(String path) throws Exception {
        this.removeChildById("TaxonomyPopup");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "TaxonomyPopup");
        uiPopup.setWindowSize(600, 250);
        UITaxonomyForm uiTaxoForm = (UITaxonomyForm)this.createUIComponent(UITaxonomyForm.class, null, null);
        uiTaxoForm.setParent(path);
        uiPopup.setUIComponent((UIComponent)uiTaxoForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
    }
}

