/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTree;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyWorkingArea;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UITree;

@ComponentConfig(template="app:/groovy/webui/component/UITreeJCRExplorer.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UITaxonomyTree
extends UIContainer {
    private Node currentNode_;
    private Node rootNode_ = null;
    private String rootPath_;

    public UITaxonomyTree() throws Exception {
        UITree tree = (UITree)this.addChild(UITree.class, null, null);
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
        tree.setIcon("nt_unstructured16x16Icon");
        tree.setSelectedIcon("nt_unstructured16x16Icon");
    }

    public void update() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        this.rootNode_ = uiManager.getRootNode();
        this.rootPath_ = this.rootNode_.getPath();
    }

    public Node getRootNode() throws Exception {
        return this.rootNode_;
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        NodeIterator children = null;
        if (this.rootNode_ == null) {
            this.update();
            this.currentNode_ = this.rootNode_;
            children = this.rootNode_.getNodes();
            this.changeNode(this.rootNode_);
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        Node nodeSelected = this.getSelectedNode();
        if (nodeSelected.getPath().equals(this.rootPath_) || this.rootNode_.getParent().getPath().equals(this.currentNode_.getPath())) {
            nodeSelected = this.rootNode_;
            children = nodeSelected.getNodes();
        }
        tree.setSelected((Object)nodeSelected);
        if (nodeSelected.getDepth() > 0) {
            tree.setParentSelected((Object)nodeSelected.getParent());
            sibbling = nodeSelected.getParent().getNodes();
            children = nodeSelected.getNodes();
        } else {
            tree.setParentSelected((Object)nodeSelected);
            sibbling = nodeSelected.getNodes();
        }
        ArrayList<Node> sibblingList = new ArrayList<Node>();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        while (sibbling.hasNext()) {
            Node sibblingNode = (Node)sibbling.next();
            if (!Utils.isReadAuthorized((Node)sibblingNode) || sibblingNode.isNodeType("exo:hiddenable")) continue;
            sibblingList.add(sibblingNode);
        }
        if (children != null) {
            while (children.hasNext()) {
                Node childrenNode = (Node)children.next();
                if (!Utils.isReadAuthorized((Node)childrenNode) || childrenNode.isNodeType("exo:hiddenable")) continue;
                childrenList.add(childrenNode);
            }
        }
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            tree.setSibbling(childrenList);
        } else {
            tree.setSibbling(sibblingList);
        }
        tree.setChildren(childrenList);
    }

    public void renderChildren() throws Exception {
        this.buildTree();
        super.renderChildren();
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setNodeSelect(String path) throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        this.currentNode_ = uiManager.getNodeByPath(path);
        if (this.rootNode_.getParent().getPath().equals(path)) {
            this.currentNode_ = this.rootNode_;
        }
        this.changeNode(this.currentNode_);
    }

    public void changeNode(Node nodeSelected) throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator nodeIter = nodeSelected.getNodes();
        while (nodeIter.hasNext()) {
            nodes.add(nodeIter.nextNode());
        }
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)uiManager.getChild(UITaxonomyWorkingArea.class);
        uiWorkingArea.setNodeList(nodes);
    }

    public Node getSelectedNode() {
        if (this.currentNode_ == null) {
            return this.rootNode_;
        }
        return this.currentNode_;
    }
}

