/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigTabPane;
import org.exoplatform.ecm.webui.component.browsecontent.UINewConfigForm;
import org.exoplatform.ecm.webui.component.browsecontent.UIScriptConfig;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class})})
public class UIScriptConfig
extends UIForm {
    protected boolean isEdit_ = false;

    public UIScriptConfig() {
        ArrayList Options = new ArrayList();
        this.addChild((UIComponent)new UIFormStringInput("repository", "repository", null));
        this.addChild((UIComponent)new UIFormStringInput("workspace", "workspace", null));
        this.addChild((UIComponent)new UIFormSelectBox("scriptName", null, Options));
        this.addChild((UIComponent)new UIFormSelectBox("template", null, Options));
        this.addChild((UIComponent)new UIFormSelectBox("detailBoxTemp", null, Options));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableTagMap", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableComment", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableVote", null, null));
        this.setActions(UINewConfigForm.DEFAULT_ACTION);
    }

    public void initForm(PortletPreferences preference, String repository, String workSpace, boolean isAddNew) throws Exception {
        String hasComment = "false";
        String hasVote = "false";
        String hasTagMap = "false";
        String scriptName = "";
        String templateName = "";
        String detailTemplate = "";
        UIFormStringInput repositoryField = (UIFormStringInput)this.getChildById("repository");
        repositoryField.setValue((Object)repository);
        repositoryField.setEditable(false);
        UIFormStringInput workSpaceField = (UIFormStringInput)this.getChildById("workspace");
        workSpaceField.setValue((Object)workSpace);
        workSpaceField.setEditable(false);
        UIFormSelectBox scriptField = (UIFormSelectBox)this.getChildById("scriptName");
        UIFormSelectBox templateField = (UIFormSelectBox)this.getChildById("template");
        UIFormSelectBox detailtemField = (UIFormSelectBox)this.getChildById("detailBoxTemp");
        UIFormCheckBoxInput enableTagMapField = (UIFormCheckBoxInput)this.getChildById("enableTagMap");
        UIFormCheckBoxInput enableCommentField = (UIFormCheckBoxInput)this.getChildById("enableComment");
        UIFormCheckBoxInput enableVoteField = (UIFormCheckBoxInput)this.getChildById("enableVote");
        scriptField.setOptions(this.getScriptOption(repository));
        templateField.setOptions(this.getTemplateOption(repository));
        UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
        if (this.isEdit_) {
            if (isAddNew) {
                this.setActions(UINewConfigForm.ADD_NEW_ACTION);
                enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
                enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
                enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
            } else {
                this.setActions(UINewConfigForm.NORMAL_ACTION);
            }
        } else {
            this.setActions(UINewConfigForm.DEFAULT_ACTION);
            repository = preference.getValue(Utils.REPOSITORY, "");
            scriptName = preference.getValue(Utils.CB_SCRIPT_NAME, "");
            scriptField.setValue(scriptName);
            templateName = preference.getValue("template", "");
            templateField.setValue(templateName);
            detailTemplate = preference.getValue(Utils.CB_BOX_TEMPLATE, "");
            detailtemField.setValue(detailTemplate);
            hasComment = preference.getValue(Utils.CB_VIEW_COMMENT, "");
            hasVote = preference.getValue(Utils.CB_VIEW_VOTE, "");
            hasTagMap = preference.getValue(Utils.CB_VIEW_TAGMAP, "");
        }
        enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
        enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
        enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
        enableCommentField.setEnable(this.isEdit_);
        enableTagMapField.setEnable(this.isEdit_);
        scriptField.setEnable(this.isEdit_);
        templateField.setEnable(this.isEdit_);
        detailtemField.setEnable(this.isEdit_);
        enableVoteField.setEnable(this.isEdit_);
    }

    public List<SelectItemOption<String>> getWorkSpaceOption() throws Exception {
        UIConfigTabPane uiTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        return uiTabPane.getWorkSpaceOption();
    }

    private List<SelectItemOption<String>> getTemplateOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> Options = new ArrayList<SelectItemOption<String>>();
        List scriptTemplates = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllTemplates("cbScriptTemplates", repository, SessionsUtils.getSystemProvider());
        for (Node template : scriptTemplates) {
            Options.add((SelectItemOption<String>)new SelectItemOption(template.getName(), (Object)template.getName()));
        }
        return Options;
    }

    private List<SelectItemOption<String>> getScriptOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> Options = new ArrayList<SelectItemOption<String>>();
        Node cbScripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getCBScriptHome(repository, SessionsUtils.getSystemProvider());
        NodeIterator nodeList = cbScripts.getNodes();
        while (nodeList.hasNext()) {
            Node node = nodeList.nextNode();
            Options.add((SelectItemOption<String>)new SelectItemOption(node.getName(), (Object)node.getName()));
        }
        return Options;
    }
}

