/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.jcr.ECMViewComponent;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={ViewNodeActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class})})
public class UIDocumentInfo
extends UIContainer
implements ECMViewComponent {
    private static final String CONTENT_PAGE_ITERATOR_ID = "UIContentPageIterator".intern();
    private String typeSort_ = "Type";
    private String typeSortOrder_ = "Ascending";
    private String nameSortOrder_ = "Ascending";
    private Node currentNode_;
    private UIPageIterator pageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, CONTENT_PAGE_ITERATOR_ID);

    public UIPageIterator getContentPageIterator() {
        return this.pageIterator_;
    }

    public String getTemplate() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer.getPreference().isJcrEnable()) {
            return uiExplorer.getDocumentInfoTemplate();
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        try {
            Node node = uiExplorer.getCurrentNode();
            String template = templateService.getTemplatePath(node, false);
            if (template != null) {
                return template;
            }
        }
        catch (AccessDeniedException ace) {
            try {
                uiExplorer.setSelectNode(uiExplorer.getRootNode());
                Object[] args = new Object[]{uiExplorer.getCurrentNode().getName()};
                throw new MessageException(new ApplicationMessage("UIDocumentInfo.msg.access-denied", args, 1));
            }
            catch (Exception exc) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uiExplorer.getDocumentInfoTemplate();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public UIRightClickPopupMenu getContextMenu() {
        return (UIRightClickPopupMenu)((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getChild(UIRightClickPopupMenu.class);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.getRepository());
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return SessionsUtils.getSystemProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public String getCapacityOfFile(Node file) throws Exception {
        Node contentNode = file.getNode("jcr:content");
        long size = contentNode.getProperty("jcr:data").getLength();
        long capacity = size / 1024L;
        String strCapacity = Long.toString(capacity);
        if (strCapacity.indexOf(".") > -1) {
            return strCapacity.substring(0, strCapacity.lastIndexOf("."));
        }
        return strCapacity;
    }

    public List<String> getMultiValues(Node node, String name) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getMultiValues(node, name);
    }

    public boolean isSystemWorkspace() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ManageableRepository manaRepoService = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(uiExplorer.getRepositoryName());
        String systemWsName = manaRepoService.getConfiguration().getSystemWorkspaceName();
        return systemWsName.equals(uiExplorer.getCurrentWorkspace());
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        String mimeType = jcrContentNode.getProperty("jcr:mimeType").getString();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, mimeType);
        MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
        String ext = mimeTypeResolver.getExtension(mimeType);
        String fileName = node.getName();
        if (fileName.lastIndexOf("." + ext) < 0) {
            fileName = fileName + "." + ext;
        }
        dresource.setDownloadName(fileName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public Node getViewNode(String nodeType) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode().getNode(nodeType);
    }

    public Node getNodeByPath(String nodePath, String workspace) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.getRepository());
        Session session = SessionsUtils.getSystemProvider().getSession(workspace, manageRepo);
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getNodeByPath(nodePath, session);
    }

    public String getActionsList(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getActionsList(node);
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomActions(node);
    }

    public boolean isPreferenceNode(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).isPreferenceNode(node);
    }

    public boolean isReadAuthorized(ExtendedNode node) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isReadAuthorized(node);
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            service = this.getApplicationComponent(clazz);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return service;
    }

    public String getNodeOwner(Node node) throws RepositoryException {
        if (node.hasProperty("exo:owner")) {
            return node.getProperty("exo:owner").getString();
        }
        return SystemIdentity.ANONIM;
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public Date getDateModified(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            return node.getProperty("exo:dateModified").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.currentNode_.hasProperty("exo:relation")) {
            Value[] vals = this.currentNode_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public List<Node> getAttachments() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.currentNode_.getNodes();
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = Utils.getListAllowedFileType((Node)this.currentNode_, (String)this.getRepository(), (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            return templateService.isManagedNodeType(nodeTypeName, this.getRepository());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.currentNode_);
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public String getVersionName(Node node) throws Exception {
        return node.getBaseVersion().getName();
    }

    public void setNode(Node node) {
        this.currentNode_ = node;
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getWorkspaceName() throws Exception {
        return this.currentNode_.getSession().getWorkspace().getName();
    }

    public Node getNode() throws Exception {
        this.currentNode_ = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        if (this.currentNode_.hasProperty("exo:language")) {
            String defaultLang = this.currentNode_.getProperty("exo:language").getString();
            if (this.getLanguage() == null) {
                this.setLanguage(defaultLang);
            }
            if (!this.getLanguage().equals(defaultLang)) {
                Node curNode = this.currentNode_.getNode("languages" + Utils.SLASH + this.getLanguage());
                return curNode;
            }
        }
        return this.currentNode_;
    }

    public Node getOriginalNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public String getIcons(Node node, String size) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.currentNode_, this.getLanguage());
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, this.getRepository());
    }

    public String getLanguage() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getLanguage();
    }

    public void setLanguage(String language) {
        ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).setLanguage(language);
    }

    public void updatePageListData() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Preference pref = uiExplorer.getPreference();
        Node currentNode = uiExplorer.getCurrentNode();
        List childrenList = new ArrayList();
        childrenList = !uiExplorer.isViewTag() ? uiExplorer.getChildrenList(currentNode, pref.isShowPreferenceDocuments()) : uiExplorer.getDocumentByTag();
        int nodesPerPage = pref.getNodesPerPage();
        ObjectPageList pageList = new ObjectPageList(childrenList, nodesPerPage);
        this.pageIterator_.setPageList((PageList)pageList);
    }

    public List<Node> getChildrenList() throws Exception {
        return this.pageIterator_.getCurrentPageData();
    }

    public String getTypeSort() {
        return this.typeSort_;
    }

    public String getTypeSortOrder() {
        return this.typeSortOrder_;
    }

    public String getNameSortOrder() {
        return this.nameSortOrder_;
    }

    public String encodeHTML(String text) {
        return Utils.encodeHTML((String)text);
    }

    static /* synthetic */ String access$002(UIDocumentInfo x0, String x1) {
        x0.typeSortOrder_ = x1;
        return x0.typeSortOrder_;
    }

    static /* synthetic */ String access$102(UIDocumentInfo x0, String x1) {
        x0.typeSort_ = x1;
        return x0.typeSort_;
    }

    static /* synthetic */ String access$202(UIDocumentInfo x0, String x1) {
        x0.nameSortOrder_ = x1;
        return x0.nameSortOrder_;
    }

    static /* synthetic */ Node access$300(UIDocumentInfo x0) {
        return x0.currentNode_;
    }
}

