/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.benchmark.preparation.repository;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

public class FastAPI {
    private SearchManager searchIndex;
    private PlainChangesLogImpl chahgesLog;
    protected Log log = ExoLogger.getLogger((String)"repload.FastAPI");
    SessionImpl session = null;
    WorkspaceDataContainerBase workspaceDataContainer;
    FileCleaner fileCleaner = null;
    WorkspaceStorageConnection con = null;
    Calendar date = null;

    public FastAPI(SessionImpl session) {
        try {
            this.session = session;
            this.workspaceDataContainer = (WorkspaceDataContainerBase)session.getContainer().getComponentInstanceOfType(WorkspaceDataContainerBase.class);
            WorkspaceFileCleanerHolder holder = (WorkspaceFileCleanerHolder)session.getContainer().getComponentInstanceOfType(WorkspaceFileCleanerHolder.class);
            this.fileCleaner = holder.getFileCleaner();
            this.con = this.getConnection();
            this.chahgesLog = new PlainChangesLogImpl();
            this.searchIndex = (SearchManager)session.getContainer().getComponentInstanceOfType(SearchManager.class);
            this.date = Calendar.getInstance();
            LocationFactory locationFactory = session.getLocationFactory();
            DCPropertyQName.dcElementSet = locationFactory.parseJCRName("dc:elementSet").getInternalName();
            DCPropertyQName.dcTitle = locationFactory.parseJCRName("dc:title").getInternalName();
            DCPropertyQName.dcCreator = locationFactory.parseJCRName("dc:creator").getInternalName();
            DCPropertyQName.dcSubject = locationFactory.parseJCRName("dc:subject").getInternalName();
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in the constructor", (Throwable)e);
        }
    }

    public void release() {
        try {
            this.commit();
        }
        catch (Exception ignore) {
            this.log.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
        }
    }

    public void commit() {
        try {
            this.con.commit();
            this.con = this.getConnection();
            this.saveChangesLog((PlainChangesLog)this.chahgesLog);
        }
        catch (Exception ignore) {
            this.log.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
        }
    }

    private void saveChangesLog(PlainChangesLog cLog) {
        this.searchIndex.onSaveItems((ItemStateChangesLog)this.chahgesLog);
        this.chahgesLog = new PlainChangesLogImpl();
    }

    private WorkspaceStorageConnection getConnection() throws Exception {
        return this.workspaceDataContainer.openConnection();
    }

    public TransientNodeData addNode(String name, int orderNum, NodeImpl parentNode) throws Exception {
        TransientNodeData nodeData = this.createNodeData_nt_folder(name, orderNum, parentNode);
        this.con.add((NodeData)nodeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)nodeData));
        TransientPropertyData primaryTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), false);
        primaryTypeData.setValue((ValueData)new TransientValueData(Constants.NT_FOLDER));
        this.con.add((PropertyData)primaryTypeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)primaryTypeData));
        TransientPropertyData createdData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_CREATED), IdGenerator.generate(), -1, 5, nodeData.getIdentifier(), false);
        createdData.setValue((ValueData)new TransientValueData(this.date));
        this.con.add((PropertyData)createdData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)createdData));
        return nodeData;
    }

    public TransientNodeData createNodeData_nt_folder(String name, int orderNum, NodeImpl parentNode) {
        InternalQName[] mixinTypeNames = new InternalQName[]{};
        InternalQName iQName = new InternalQName("", name);
        QPath path = QPath.makeChildPath((QPath)parentNode.getInternalPath(), (InternalQName)iQName);
        AccessControlList acl = new AccessControlList();
        String uuid = IdGenerator.generate();
        TransientNodeData nodeData = new TransientNodeData(path, uuid, -1, Constants.NT_FOLDER, mixinTypeNames, orderNum, parentNode.getInternalIdentifier(), acl);
        return nodeData;
    }

    public TransientNodeData addNode(String name, int orderNum, TransientNodeData parentNode) throws Exception {
        TransientNodeData nodeData = this.createNodeData(new InternalQName("", name), orderNum, parentNode, Constants.NT_FOLDER, null);
        this.con.add((NodeData)nodeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)nodeData));
        TransientPropertyData primaryTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), false);
        primaryTypeData.setValue((ValueData)new TransientValueData(Constants.NT_FOLDER));
        this.con.add((PropertyData)primaryTypeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)primaryTypeData));
        TransientPropertyData createdData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_CREATED), IdGenerator.generate(), -1, 5, nodeData.getIdentifier(), false);
        createdData.setValue((ValueData)new TransientValueData(this.date));
        this.con.add((PropertyData)createdData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)createdData));
        return nodeData;
    }

    public TransientNodeData createNodeData(InternalQName iQName, int orderNum, TransientNodeData parentNode, InternalQName primaryType, InternalQName mixinName) throws Exception {
        InternalQName[] mixinTypeNames = null;
        mixinTypeNames = mixinName == null ? new InternalQName[]{} : new InternalQName[]{mixinName};
        QPath path = QPath.makeChildPath((QPath)parentNode.getQPath(), (InternalQName)iQName);
        AccessControlList acl = new AccessControlList();
        String uuid = IdGenerator.generate();
        TransientNodeData nodeData = new TransientNodeData(path, uuid, -1, primaryType, mixinTypeNames, orderNum, parentNode.getIdentifier(), acl);
        return nodeData;
    }

    protected void addNode_file(String name, int orderNum, String metadata, TransientNodeData parentNode, TransientValueData fData, String mimeType, String title) throws Exception {
        TransientNodeData nodeData = this.createNodeData(new InternalQName("", name), orderNum, parentNode, Constants.NT_FILE, null);
        this.con.add((NodeData)nodeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)nodeData));
        TransientPropertyData primaryTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), false);
        primaryTypeData.setValue((ValueData)new TransientValueData(Constants.NT_FILE));
        this.con.add((PropertyData)primaryTypeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)primaryTypeData));
        TransientPropertyData createdData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_CREATED), IdGenerator.generate(), -1, 5, nodeData.getIdentifier(), false);
        createdData.setValue((ValueData)new TransientValueData(this.date));
        this.con.add((PropertyData)createdData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)createdData));
        TransientNodeData contentNode = this.createNodeData(Constants.JCR_CONTENT, 0, nodeData, Constants.NT_RESOURCE, DCPropertyQName.dcElementSet);
        this.con.add((NodeData)contentNode);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)contentNode));
        TransientPropertyData mixinTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_MIXINTYPES), IdGenerator.generate(), -1, 7, contentNode.getIdentifier(), true);
        mixinTypeData.setValue((ValueData)new TransientValueData(DCPropertyQName.dcElementSet));
        this.con.add((PropertyData)mixinTypeData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)mixinTypeData));
        TransientPropertyData primaryTypeContenNode = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, contentNode.getIdentifier(), false);
        primaryTypeContenNode.setValue((ValueData)new TransientValueData(Constants.NT_RESOURCE));
        this.con.add((PropertyData)primaryTypeContenNode);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)primaryTypeContenNode));
        TransientPropertyData uuidPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_UUID), IdGenerator.generate(), -1, 1, contentNode.getIdentifier(), false);
        uuidPropertyData.setValue((ValueData)new TransientValueData(IdGenerator.generate()));
        this.con.add((PropertyData)uuidPropertyData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)uuidPropertyData));
        TransientPropertyData mimeTypePropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_MIMETYPE), IdGenerator.generate(), -1, 1, contentNode.getIdentifier(), false);
        mimeTypePropertyData.setValue((ValueData)new TransientValueData(mimeType));
        this.con.add((PropertyData)mimeTypePropertyData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)mimeTypePropertyData));
        TransientPropertyData lastModifiedPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_LASTMODIFIED), IdGenerator.generate(), -1, 5, contentNode.getIdentifier(), false);
        lastModifiedPropertyData.setValue((ValueData)new TransientValueData(this.date));
        this.con.add((PropertyData)lastModifiedPropertyData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)lastModifiedPropertyData));
        TransientPropertyData dataPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_DATA), IdGenerator.generate(), -1, 2, contentNode.getIdentifier(), false);
        dataPropertyData.setValue((ValueData)fData);
        this.con.add((PropertyData)dataPropertyData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)dataPropertyData));
        this.addDcElementSet(this.con, contentNode, metadata, title);
    }

    private void addDcElementSet(WorkspaceStorageConnection con, TransientNodeData nodeData, String value, String title) throws Exception {
        this.addDCProperty(con, nodeData, DCPropertyQName.dcTitle, title);
        this.addDCProperty(con, nodeData, DCPropertyQName.dcCreator, value);
        this.addDCProperty(con, nodeData, DCPropertyQName.dcSubject, value);
    }

    private void addDCProperty(WorkspaceStorageConnection con, TransientNodeData dcNode, InternalQName propertyQName, String propertyContent) throws Exception {
        TransientPropertyData dcPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)dcNode.getQPath(), (InternalQName)propertyQName), IdGenerator.generate(), -1, 1, dcNode.getIdentifier(), true);
        dcPropertyData.setValue((ValueData)new TransientValueData(propertyContent));
        con.add((PropertyData)dcPropertyData);
        this.chahgesLog.add(ItemState.createAddedState((ItemData)dcPropertyData));
    }

    protected static class DCPropertyQName {
        public static InternalQName dcElementSet;
        public static InternalQName dcTitle;
        public static InternalQName dcCreator;
        public static InternalQName dcSubject;

        protected DCPropertyQName() {
        }
    }
}

