/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NavigationEventListenerDelegate {
    private String lifecycleName;

    public NavigationEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreateNavigation(PageNavigation pageNavigation) throws Exception {
    }

    public void updateLifecycleOnChangeNavigation(PageNavigation pageNavigation, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        this.updateRemovedPageNode(pageNavigation, remoteUser, plugin);
        this.updateAddedPageNode(pageNavigation, remoteUser);
    }

    public void updateLifecyleOnRemoveNavigation(PageNavigation pageNavigation) throws Exception {
    }

    private void updateAddedPageNode(PageNavigation pageNavigation, String remoteUser) throws Exception {
        UserPortalConfigService userPortalConfigService = PublicationUtil.getServices(UserPortalConfigService.class);
        WCMConfigurationService wcmConfigurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        for (PageNode pageNode : PublicationUtil.getAllPageNodeFromPageNavigation(pageNavigation)) {
            Page page = userPortalConfigService.getPage(pageNode.getPageReference(), remoteUser);
            if (page == null) continue;
            for (String applicationId : PublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"))) {
                Node content = PublicationUtil.getNodeByApplicationId(applicationId);
                if (content == null) continue;
                this.saveAddedPageNode(pageNavigation.getOwnerId(), pageNode, applicationId, content);
            }
        }
    }

    private void updateRemovedPageNode(PageNavigation pageNavigation, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        String portalName = pageNavigation.getOwnerId();
        ArrayList<PageNode> listPortalPageNode = PublicationUtil.getAllPageNodeFromPageNavigation(pageNavigation);
        ArrayList<String> listPortalNavigationUri = new ArrayList<String>();
        ArrayList<String> listPageReference = new ArrayList<String>();
        for (PageNode portalPageNode : listPortalPageNode) {
            String mixedNavigationNodeUri = PublicationUtil.setMixedNavigationUri(portalName, portalPageNode.getUri());
            listPortalNavigationUri.add(mixedNavigationNodeUri);
            listPageReference.add(portalPageNode.getPageReference());
        }
        RepositoryService repositoryService = PublicationUtil.getServices(RepositoryService.class);
        WCMConfigurationService wcmConfigurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = wcmConfigurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String repositoryName = nodeLocation.getRepository();
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = WCMCoreUtils.getSessionProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from " + plugin.getLifecycleType() + " where publication:lifecycleName='" + this.lifecycleName + "' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            Node content = nodeIterator.nextNode();
            String navigationNodeUri = "";
            for (String existedNavigationNodeUri : PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs")) {
                if (!existedNavigationNodeUri.startsWith("/" + portalName) || listPortalNavigationUri.contains(existedNavigationNodeUri)) continue;
                navigationNodeUri = existedNavigationNodeUri;
            }
            String pageId = "";
            String applicationId = "";
            for (String existedPageId : PublicationUtil.getValuesAsString(content, "publication:webPageIDs")) {
                if (!existedPageId.contains("::" + portalName + "::") || listPageReference.contains(existedPageId)) continue;
                pageId = existedPageId;
            }
            if (!pageId.equals("")) {
                UserPortalConfigService userPortalConfigService = PublicationUtil.getServices(UserPortalConfigService.class);
                Page page = userPortalConfigService.getPage(pageId, remoteUser);
                for (String applicationIdTmp : PublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"))) {
                    applicationIdTmp = PublicationUtil.setMixedApplicationId(pageId, applicationIdTmp);
                    List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
                    if (!listExistedApplicationId.contains(applicationIdTmp)) continue;
                    applicationId = applicationIdTmp;
                }
            }
            this.saveRemovedPageNode(navigationNodeUri, pageId, applicationId, content);
        }
        session.logout();
        sessionProvider.close();
    }

    private void saveAddedPageNode(String portalName, PageNode pageNode, String applicationId, Node content) throws Exception {
        List<String> listExistedWebPageId;
        String mixedNavigationNodeUri;
        List<String> listExistedNavigationNodeUri;
        String mixedApplicationId;
        PublicationService publicationService = PublicationUtil.getServices(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!this.lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        if (!listExistedApplicationId.contains(mixedApplicationId = PublicationUtil.setMixedApplicationId(pageNode.getPageReference(), applicationId))) {
            listExistedApplicationId.add(mixedApplicationId);
            content.setProperty("publication:applicationIDs", PublicationUtil.toValues(valueFactory, listExistedApplicationId));
        }
        if (!(listExistedNavigationNodeUri = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs")).contains(mixedNavigationNodeUri = PublicationUtil.setMixedNavigationUri(portalName, pageNode.getUri()))) {
            listExistedNavigationNodeUri.add(mixedNavigationNodeUri);
            content.setProperty("publication:navigationNodeURIs", PublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        }
        if (!(listExistedWebPageId = PublicationUtil.getValuesAsString(content, "publication:webPageIDs")).contains(pageNode.getPageReference())) {
            listExistedWebPageId.add(pageNode.getPageReference());
            content.setProperty("publication:webPageIDs", PublicationUtil.toValues(valueFactory, listExistedWebPageId));
        }
        session.save();
    }

    private void saveRemovedPageNode(String navigationNodeUri, String pageId, String applicationId, Node content) throws Exception {
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedNavigationNodeUri = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        if (navigationNodeUri != null && navigationNodeUri.length() > 0 && listExistedNavigationNodeUri.contains(navigationNodeUri)) {
            listExistedNavigationNodeUri.remove(navigationNodeUri);
            content.setProperty("publication:navigationNodeURIs", PublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        }
        List<String> listExistedPageId = PublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        if (pageId != null && pageId.length() > 0 && listExistedPageId.contains(pageId)) {
            listExistedPageId.remove(pageId);
            content.setProperty("publication:webPageIDs", PublicationUtil.toValues(valueFactory, listExistedPageId));
        }
        List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        if (applicationId != null && applicationId.length() > 0 && listExistedApplicationId.contains(applicationId)) {
            listExistedApplicationId.remove(applicationId);
            content.setProperty("publication:applicationIDs", PublicationUtil.toValues(valueFactory, listExistedApplicationId));
        }
        session.save();
    }
}

