/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationUtil;

public class NavigationEventListenerDelegate {
    private String lifecycleName;

    public NavigationEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreateNavigation(PageNavigation pageNavigation) throws Exception {
    }

    public void updateLifecycleOnChangeNavigation(PageNavigation pageNavigation, String remoteUser) throws Exception {
        if (pageNavigation.getOwnerType().equals("portal")) {
            this.updateRemovedPageNode(pageNavigation, remoteUser);
            this.updateAddedPageNode(pageNavigation, remoteUser);
        }
    }

    public void updateLifecyleOnRemoveNavigation(PageNavigation pageNavigation) throws Exception {
    }

    private void updateAddedPageNode(PageNavigation pageNavigation, String remoteUser) throws Exception {
        UserPortalConfigService userPortalConfigService = StageAndVersionPublicationUtil.getServices(UserPortalConfigService.class);
        WCMConfigurationService wcmConfigurationService = StageAndVersionPublicationUtil.getServices(WCMConfigurationService.class);
        for (PageNode pageNode : pageNavigation.getNodes()) {
            Page page = userPortalConfigService.getPage(pageNode.getPageReference(), remoteUser);
            if (page == null) continue;
            for (String applicationId : StageAndVersionPublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"))) {
                List<String> listExistedApplicationId;
                Node content = StageAndVersionPublicationUtil.getNodeByApplicationId(applicationId);
                if (content == null || (listExistedApplicationId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs")).contains(StageAndVersionPublicationUtil.setMixedApplicationId(page.getPageId(), applicationId))) continue;
                this.saveAddedPageNode(pageNavigation.getOwnerId(), pageNode, applicationId, content);
            }
        }
    }

    private void updateRemovedPageNode(PageNavigation pageNavigation, String remoteUser) throws Exception {
        String portalName = pageNavigation.getOwnerId();
        ArrayList listPortalPageNode = pageNavigation.getNodes();
        ArrayList<String> listPortalNavigationUri = new ArrayList<String>();
        ArrayList<String> listPageReference = new ArrayList<String>();
        for (PageNode portalPageNode : listPortalPageNode) {
            String mixedNavigationNodeUri = StageAndVersionPublicationUtil.setMixedNavigationUri(portalName, portalPageNode.getUri());
            listPortalNavigationUri.add(mixedNavigationNodeUri);
            listPageReference.add(portalPageNode.getPageReference());
        }
        RepositoryService repositoryService = StageAndVersionPublicationUtil.getServices(RepositoryService.class);
        WCMConfigurationService wcmConfigurationService = StageAndVersionPublicationUtil.getServices(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = wcmConfigurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String repositoryName = nodeLocation.getRepository();
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from publication:webpagesPublication where publication:lifecycleName='" + this.lifecycleName + "' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            Node content = nodeIterator.nextNode();
            String navigationNodeUri = "";
            for (String existedNavigationNodeUri : StageAndVersionPublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs")) {
                if (!existedNavigationNodeUri.startsWith("/" + portalName) || listPortalNavigationUri.contains(existedNavigationNodeUri)) continue;
                navigationNodeUri = existedNavigationNodeUri;
            }
            String pageId = "";
            for (String existedPageId : StageAndVersionPublicationUtil.getValuesAsString(content, "publication:webPageIDs")) {
                if (listPageReference.contains(existedPageId) || listPortalNavigationUri.contains(navigationNodeUri)) continue;
                pageId = existedPageId;
            }
            if (pageId.equals("")) continue;
            String applicationId = "";
            UserPortalConfigService userPortalConfigService = StageAndVersionPublicationUtil.getServices(UserPortalConfigService.class);
            Page page = userPortalConfigService.getPage(pageId, remoteUser);
            for (String applicationIdTmp : StageAndVersionPublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"))) {
                applicationIdTmp = StageAndVersionPublicationUtil.setMixedApplicationId(pageId, applicationIdTmp);
                List<String> listExistedApplicationId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs");
                if (!listExistedApplicationId.contains(applicationIdTmp)) continue;
                applicationId = applicationIdTmp;
            }
            this.saveRemovedPageNode(navigationNodeUri, pageId, applicationId, content);
        }
        sessionProvider.close();
    }

    private void saveAddedPageNode(String portalName, PageNode pageNode, String applicationId, Node content) throws Exception {
        String mixedApplicationId;
        PublicationService publicationService = StageAndVersionPublicationUtil.getServices(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!this.lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        if (listExistedApplicationId.contains(mixedApplicationId = StageAndVersionPublicationUtil.setMixedApplicationId(pageNode.getPageReference(), applicationId))) {
            return;
        }
        listExistedApplicationId.add(mixedApplicationId);
        content.setProperty("publication:applicationIDs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedApplicationId));
        List<String> listExistedNavigationNodeUri = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        String mixedNavigationNodeUri = StageAndVersionPublicationUtil.setMixedNavigationUri(portalName, pageNode.getUri());
        listExistedNavigationNodeUri.add(mixedNavigationNodeUri);
        content.setProperty("publication:navigationNodeURIs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        List<String> listExistedWebPageId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        listExistedWebPageId.add(pageNode.getPageReference());
        content.setProperty("publication:webPageIDs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedWebPageId));
        session.save();
    }

    private void saveRemovedPageNode(String navigationNodeUri, String pageId, String applicationId, Node content) throws Exception {
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedNavigationNodeUri = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        List<String> listExistedNavigationNodeUriTmp = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        if (listExistedNavigationNodeUri.contains(navigationNodeUri)) {
            listExistedNavigationNodeUriTmp.remove(navigationNodeUri);
        }
        content.setProperty("publication:navigationNodeURIs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedNavigationNodeUriTmp));
        List<String> listExistedPageId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        List<String> listExistedPageIdTmp = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        if (listExistedPageId.contains(pageId)) {
            listExistedPageIdTmp.remove(pageId);
        }
        content.setProperty("publication:webPageIDs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedPageIdTmp));
        List<String> listExistedApplicationId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        List<String> listExistedApplicationIdTmp = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        if (listExistedApplicationId.contains(applicationId)) {
            listExistedApplicationIdTmp.remove(applicationId);
        }
        content.setProperty("publication:applicationIDs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedApplicationIdTmp));
        session.save();
    }
}

