/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.category;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyConfig;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class CategoryInitializationPlugin
extends TaxonomyPlugin {
    private String treeName = "";
    private boolean autoCreateInNewRepository = true;
    private RepositoryService repositoryService;
    private TaxonomyService taxonomyService;
    private ActionServiceContainer actionServiceContainer;
    private DMSConfiguration dmsConfiguration;
    private InitParams params;

    public CategoryInitializationPlugin(InitParams params, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, TaxonomyService taxonomyService, ActionServiceContainer actionServiceContainer, DMSConfiguration dmsConfiguration) throws Exception {
        super(params, repositoryService, nodeHierarchyCreator, taxonomyService, actionServiceContainer, dmsConfiguration);
        this.repositoryService = repositoryService;
        this.taxonomyService = taxonomyService;
        this.actionServiceContainer = actionServiceContainer;
        this.dmsConfiguration = dmsConfiguration;
        this.params = params;
        ValueParam autoCreated = params.getValueParam("autoCreateInNewRepository");
        ValueParam workspaceParam = params.getValueParam("workspace");
        ValueParam pathParam = params.getValueParam("path");
        ValueParam nameParam = params.getValueParam("treeName");
        if (autoCreated != null) {
            this.autoCreateInNewRepository = Boolean.parseBoolean(autoCreated.getValue());
        }
        if (pathParam == null || workspaceParam == null || workspaceParam.getValue().trim().length() == 0) {
            this.setPath(nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath"));
        } else {
            this.setPath(pathParam.getValue());
            this.setWorkspace(workspaceParam.getValue());
        }
        if (nameParam != null) {
            this.treeName = nameParam.getValue();
        }
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository) {
            for (RepositoryEntry repositoryEntry : this.repositoryService.getConfig().getRepositoryConfigurations()) {
                this.importPredefineTaxonomies(repositoryEntry.getName());
            }
            return;
        }
        ValueParam param = this.params.getValueParam("repository");
        String repository = null;
        repository = param == null ? this.repositoryService.getDefaultRepository().getConfiguration().getName() : param.getValue();
        this.importPredefineTaxonomies(repository);
    }

    private void importPredefineTaxonomies(String repository) throws Exception {
        Session session;
        Node taxonomyStorageNode;
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration.getConfig(repository);
        if (this.getWorkspace() == null) {
            this.setWorkspace(dmsRepoConfig.getSystemWorkspace());
        }
        if ((taxonomyStorageNode = (Node)(session = manageableRepository.getSystemSession(this.getWorkspace())).getItem(this.getPath())).hasProperty("exo:isImportedChildren")) {
            session.logout();
            return;
        }
        taxonomyStorageNode.setProperty("exo:isImportedChildren", true);
        Iterator it = this.params.getObjectParamIterator();
        Node taxonomyStorageNodeSystem = Utils.makePath((Node)taxonomyStorageNode, (String)this.treeName, (String)"exo:taxonomy", null);
        session.save();
        while (it.hasNext()) {
            TaxonomyConfig config;
            ObjectParameter objectParam = (ObjectParameter)it.next();
            if (objectParam.getName().equals("permission.configuration")) {
                config = (TaxonomyConfig)objectParam.getObject();
                for (TaxonomyConfig.Taxonomy taxonomy : config.getTaxonomies()) {
                    Map mapPermissions = this.getPermissions(taxonomy.getPermissions());
                    if (mapPermissions != null) {
                        ((ExtendedNode)taxonomyStorageNodeSystem).setPermissions(mapPermissions);
                    }
                    if (!taxonomyStorageNodeSystem.canAddMixin("mix:referenceable")) continue;
                    taxonomyStorageNodeSystem.addMixin("mix:referenceable");
                }
                continue;
            }
            if (objectParam.getName().equals("taxonomy.configuration")) {
                config = (TaxonomyConfig)objectParam.getObject();
                for (TaxonomyConfig.Taxonomy taxonomy : config.getTaxonomies()) {
                    Node taxonomyNode = Utils.makePath((Node)taxonomyStorageNodeSystem, (String)taxonomy.getPath(), (String)"exo:taxonomy", (Map)this.getPermissions(taxonomy.getPermissions()));
                    if (taxonomyNode.canAddMixin("mix:referenceable")) {
                        taxonomyNode.addMixin("mix:referenceable");
                    }
                    taxonomyNode.getSession().save();
                }
                continue;
            }
            if (!objectParam.getName().equals("predefined.actions")) continue;
            config = (ActionConfig)objectParam.getObject();
            List actions = config.getActions();
            for (ActionConfig.TaxonomyAction action : actions) {
                this.addAction(action, taxonomyStorageNodeSystem, repository);
            }
        }
        taxonomyStorageNode.save();
        try {
            this.taxonomyService.addTaxonomyTree(taxonomyStorageNodeSystem);
        }
        catch (TaxonomyAlreadyExistsException e) {
            e.printStackTrace();
        }
        session.save();
        session.logout();
    }

    private void addAction(ActionConfig.TaxonomyAction action, Node srcNode, String repository) throws Exception {
        HashMap<String, JcrInputProperty> sortedInputs = new HashMap<String, JcrInputProperty>();
        JcrInputProperty jcrInputName = new JcrInputProperty();
        jcrInputName.setJcrPath("/node/exo:name");
        jcrInputName.setValue((Object)action.getName());
        sortedInputs.put("/node/exo:name", jcrInputName);
        JcrInputProperty jcrInputDes = new JcrInputProperty();
        jcrInputDes.setJcrPath("/node/exo:description");
        jcrInputDes.setValue((Object)action.getDescription());
        sortedInputs.put("/node/exo:description", jcrInputDes);
        JcrInputProperty jcrInputLife = new JcrInputProperty();
        jcrInputLife.setJcrPath("/node/exo:lifecyclePhase");
        jcrInputLife.setValue((Object)action.getLifecyclePhase());
        sortedInputs.put("/node/exo:lifecyclePhase", jcrInputLife);
        JcrInputProperty jcrInputHomePath = new JcrInputProperty();
        jcrInputHomePath.setJcrPath("/node/exo:storeHomePath");
        jcrInputHomePath.setValue((Object)action.getHomePath());
        sortedInputs.put("/node/exo:storeHomePath", jcrInputHomePath);
        JcrInputProperty jcrInputTargetWspace = new JcrInputProperty();
        jcrInputTargetWspace.setJcrPath("/node/exo:targetWorkspace");
        jcrInputTargetWspace.setValue((Object)action.getTargetWspace());
        sortedInputs.put("/node/exo:targetWorkspace", jcrInputTargetWspace);
        JcrInputProperty jcrInputTargetPath = new JcrInputProperty();
        jcrInputTargetPath.setJcrPath("/node/exo:targetPath");
        jcrInputTargetPath.setValue((Object)action.getTargetPath());
        sortedInputs.put("/node/exo:targetPath", jcrInputTargetPath);
        JcrInputProperty rootProp = (JcrInputProperty)sortedInputs.get("/node");
        if (rootProp == null) {
            rootProp = new JcrInputProperty();
            rootProp.setJcrPath("/node");
            rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
            sortedInputs.put("/node", rootProp);
        } else {
            rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
        }
        this.actionServiceContainer.addAction(srcNode, repository, action.getType(), sortedInputs);
        Node actionNode = this.actionServiceContainer.getAction(srcNode, action.getName());
        if (action.getRoles() != null) {
            String[] roles = StringUtils.split((String)action.getRoles(), (String)";");
            actionNode.setProperty("exo:roles", roles);
        }
        for (ActionConfig.Mixin mixin : action.getMixins()) {
            actionNode.addMixin(mixin.getName());
            Map props = mixin.getParsedProperties();
            Set keys = props.keySet();
            for (String key : keys) {
                actionNode.setProperty(key, (String)props.get(key));
            }
        }
        actionNode.getSession().save();
    }
}

