/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.listener;

import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.jcr.DataStorageImpl;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveLivePortalEventListener
extends Listener<DataStorageImpl, PortalConfig> {
    private Log log = ExoLogger.getLogger(RemoveLivePortalEventListener.class);

    public void onEvent(Event<DataStorageImpl, PortalConfig> event) throws Exception {
        PortalConfig portalConfig = (PortalConfig)event.getData();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)container.getComponentInstanceOfType(LivePortalManagerService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSessionProvider();
        ManageDriveService manageDriveService = (ManageDriveService)container.getComponentInstanceOfType(ManageDriveService.class);
        String drive = portalConfig.getName();
        try {
            Node portal = livePortalManagerService.getLivePortal(sessionProvider, portalConfig.getName());
            String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
            manageDriveService.removeDrive(drive, repository);
            livePortalManagerService.removeLivePortal(sessionProvider, portalConfig);
            this.log.info((Object)("Resources storage of portal: " + portalConfig.getName() + " was invalid"));
        }
        catch (Exception e) {
            this.log.error((Object)("Exception when remove resources storage for portal: " + portalConfig.getName()), e.fillInStackTrace());
        }
        sessionProvider.close();
    }
}

