/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.webui.skin.ResourceResolver;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.skin.WCMSkinResourceResolver;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class XSkinService
implements Startable {
    private static String SHARED_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' and exo:sharedCSS='true' order by exo:priority DESC".intern();
    private static String WEBCONTENT_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' order by exo:priority DESC".intern();
    public static final String SKIN_PATH_REGEXP = "/(.*)/css/jcr/(.*)/(.*)/(.*).css".intern();
    private static final String SKIN_PATH_PATTERN = "/{docBase}/css/jcr/(.*)/(.*)/Stylesheet.css".intern();
    private static Log log = ExoLogger.getLogger((String)"wcm:XSkinService");
    private WebSchemaConfigService schemaConfigService;
    private WCMConfigurationService configurationService;
    private SkinService skinService = WCMCoreUtils.getService(SkinService.class);
    private ServletContext servletContext;

    public XSkinService() throws Exception {
        this.skinService.addResourceResolver((ResourceResolver)new WCMSkinResourceResolver(this.skinService));
        this.configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
        this.schemaConfigService = WCMCoreUtils.getService(WebSchemaConfigService.class);
        this.servletContext = WCMCoreUtils.getService(ServletContext.class);
    }

    public String getActiveStylesheet(Node webcontent) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String cssQuery = StringUtils.replaceOnce((String)WEBCONTENT_CSS_QUERY, (String)"{path}", (String)webcontent.getPath());
        NodeLocation webcontentLocation = NodeLocation.make(webcontent);
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository repository = repositoryService.getRepository(webcontentLocation.getRepository());
        Session session = null;
        session = webcontentLocation.getPath().startsWith("/jcr:system") ? repository.getSystemSession(repository.getConfiguration().getSystemWorkspaceName()) : repository.getSystemSession(webcontentLocation.getWorkspace());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(cssQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        while (iterator.hasNext()) {
            Node registeredCSSFile = iterator.nextNode();
            buffer.append(registeredCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
        }
        session.logout();
        return buffer.toString();
    }

    public void updatePortalSkinOnModify(Node portal, Node cssFile) throws Exception {
        String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal, cssFile, false);
        } else {
            this.addPortalSkin(portal, cssFile, false);
        }
    }

    public void updatePortalSkinOnRemove(Node portal, Node cssFile) throws Exception {
        String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal, cssFile, false);
        } else {
            this.addPortalSkin(portal, cssFile, false);
        }
    }

    private void addPortalSkin(Node portalNode, Node cssFile, boolean isStartup) throws Exception {
        String cssData = this.mergeCSSData(portalNode, cssFile, isStartup);
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portalNode.getName()).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.addSkin(portalNode.getName(), skinName, skinPath, cssData);
        }
    }

    private void addSharedPortalSkin(Node portalNode, Node cssFile, boolean isAddNew) throws Exception {
        String cssData = this.mergeCSSData(portalNode, cssFile, isAddNew);
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portalNode.getName()).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.addPortalSkin(portalNode.getName(), skinName, skinPath, cssData);
        }
    }

    private String mergeCSSData(Node portalNode, Node newCSSFile, boolean isStartup) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Node cssFolder = this.schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class).getCSSFolder(portalNode);
        String statement = StringUtils.replaceOnce((String)SHARED_CSS_QUERY, (String)"{path}", (String)cssFolder.getPath());
        QueryManager queryManager = portalNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(statement, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        if (isStartup) {
            while (iterator.hasNext()) {
                Node registeredCSSFile = iterator.nextNode();
                buffer.append(registeredCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
            }
        } else {
            boolean isAdded = false;
            while (iterator.hasNext()) {
                Node registeredCSSFile = iterator.nextNode();
                long newCSSFilePriority = newCSSFile.getProperty("exo:priority").getLong();
                long registeredCSSFilePriority = registeredCSSFile.getProperty("exo:priority").getLong();
                if (!isAdded && newCSSFilePriority < registeredCSSFilePriority) {
                    buffer.append(newCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
                    isAdded = true;
                    continue;
                }
                if (newCSSFile.getPath().equals(registeredCSSFile.getPath())) {
                    buffer.append(newCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
                    continue;
                }
                buffer.append(registeredCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
            }
        }
        return buffer.toString();
    }

    public void start() {
        SessionProvider sessionProvider = WCMCoreUtils.getSessionProvider();
        try {
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalSkin(sharedPortal, null, true);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalSkin(portal, null, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception when start XSkinService", e.fillInStackTrace());
        }
        sessionProvider.close();
    }

    public void stop() {
    }
}

