/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedNodeIterator
extends PageList {
    protected List<Node> nodes;

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public PaginatedNodeIterator(int pageSize) {
        super(pageSize);
    }

    public PaginatedNodeIterator(List<Node> nodes, int pageSize) {
        super(pageSize);
        this.nodes = nodes;
        this.setAvailablePage(nodes.size());
        this.currentListPage_ = null;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null) {
            return;
        }
        this.checkAndSetPosition(page);
        this.currentListPage_ = new ArrayList();
        int count = 0;
        for (int i = (page - 1) * this.getPageSize(); i < this.nodes.size(); ++i) {
            this.currentListPage_.add(this.nodes.get(i));
            if (++count == this.getPageSize()) break;
        }
        this.currentPage_ = page;
    }

    public int getTotalPages() {
        return this.getAvailablePage();
    }

    public int getNodesPerPage() {
        return this.getPageSize();
    }

    public long getTotalNodes() {
        return this.nodes.size();
    }

    public List getCurrentPageData() throws Exception {
        return this.currentPage();
    }

    public List getPage(int page) throws Exception {
        if (page < 1 || page > this.availablePage_) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.populateCurrentPage(page);
        return this.currentListPage_;
    }

    public void changePage(int page) throws Exception {
        this.populateCurrentPage(page);
    }

    protected void checkAndSetPosition(int page) {
        try {
            if (page > this.currentPage_) {
                long skipNextNum = (page - (this.currentPage_ + 1)) * this.getPageSize();
                ((TwoWayRangeIterator)this.nodes).skip(skipNextNum);
            } else if (page < this.currentPage_) {
                int currentPageSize = this.currentListPage_.size();
                long skipBackNum = (this.currentPage_ - page) * this.getPageSize() + currentPageSize;
                ((TwoWayRangeIterator)this.nodes).skipBack(skipBackNum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getAll() throws Exception {
        throw new UnsupportedOperationException();
    }
}

