/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.PageTemplateConfig;
import org.exoplatform.portal.config.model.Gadgets;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewPortalConfigListener
extends org.exoplatform.portal.config.NewPortalConfigListener {
    private ConfigurationManager cmanager_;
    private DataStorage pdcService_;
    private List<?> configs;
    private PageTemplateConfig pageTemplateConfig_;
    private String defaultPortal;
    private boolean isUseTryCatch;
    private Log log = ExoLogger.getLogger((String)"Portal:NewPortalConfigListener");

    public NewPortalConfigListener(DataStorage pdcService, ConfigurationManager cmanager, InitParams params) throws Exception {
        super(pdcService, cmanager, params);
        this.cmanager_ = cmanager;
        this.pdcService_ = pdcService;
        ObjectParameter objectParam = params.getObjectParam("page.templates");
        if (objectParam != null) {
            this.pageTemplateConfig_ = (PageTemplateConfig)objectParam.getObject();
        }
        this.defaultPortal = "classic";
        ValueParam valueParam = params.getValueParam("default.portal");
        if (valueParam != null) {
            this.defaultPortal = valueParam.getValue();
        }
        if (this.defaultPortal == null || this.defaultPortal.trim().length() == 0) {
            this.defaultPortal = "classic";
        }
        this.configs = params.getObjectParamValues(NewPortalConfig.class);
        valueParam = params.getValueParam("initializing.failure.ignore");
        this.isUseTryCatch = valueParam != null ? valueParam.getValue().toLowerCase().equals("true") : true;
    }

    public void run() throws Exception {
        if (this.isInitedDB(this.defaultPortal)) {
            return;
        }
        if (this.isUseTryCatch) {
            for (Object ele : this.configs) {
                try {
                    NewPortalConfig portalConfig = (NewPortalConfig)ele;
                    if (portalConfig.getOwnerType().equals("user")) {
                        this.initUserTypeDB(portalConfig);
                    } else if (portalConfig.getOwnerType().equals("group")) {
                        this.initGroupTypeDB(portalConfig);
                    } else {
                        this.initPortalTypeDB(portalConfig);
                    }
                    portalConfig.getPredefinedOwner().clear();
                }
                catch (Exception e) {
                    System.err.println("NewPortalConfig error: " + e.getMessage());
                }
            }
        } else {
            for (Object ele : this.configs) {
                NewPortalConfig portalConfig = (NewPortalConfig)ele;
                if (portalConfig.getOwnerType().equals("user")) {
                    this.initUserTypeDB(portalConfig);
                } else if (portalConfig.getOwnerType().equals("group")) {
                    this.initGroupTypeDB(portalConfig);
                } else {
                    this.initPortalTypeDB(portalConfig);
                }
                portalConfig.getPredefinedOwner().clear();
            }
        }
    }

    NewPortalConfig getPortalConfig(String ownerType) {
        for (Object object : this.configs) {
            NewPortalConfig portalConfig = (NewPortalConfig)object;
            if (!portalConfig.getOwnerType().equals(ownerType)) continue;
            return portalConfig;
        }
        return null;
    }

    private boolean isInitedDB(String user) throws Exception {
        PortalConfig pconfig = this.pdcService_.getPortalConfig(user);
        return pconfig != null;
    }

    public void initUserTypeDB(NewPortalConfig config) throws Exception {
        HashSet owners = config.getPredefinedOwner();
        for (String owner : owners) {
            this.createPage(config, owner);
            this.createPageNavigation(config, owner);
            this.createGadgets(config, owner);
        }
    }

    public void initGroupTypeDB(NewPortalConfig config) throws Exception {
        HashSet owners = config.getPredefinedOwner();
        for (String owner : owners) {
            this.createPage(config, owner);
            this.createPageNavigation(config, owner);
            this.createPortletPreferences(config, owner);
        }
    }

    public void initPortalTypeDB(NewPortalConfig config) throws Exception {
        HashSet owners = config.getPredefinedOwner();
        for (String owner : owners) {
            this.createPortalConfig(config, owner);
            this.createPage(config, owner);
            this.createPageNavigation(config, owner);
            this.createPortletPreferences(config, owner);
        }
    }

    private void createPortalConfig(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        boolean isTemplate = config.getTemplateOwner() != null && config.getTemplateOwner().trim().length() > 0;
        String path = this.getPathConfig(config, owner, "portal", isTemplate);
        try {
            xml = this.getDefaultConfig(config.getTemplateLocation(), path);
            if (isTemplate) {
                xml = StringUtils.replace((String)xml, (String)"@owner@", (String)owner);
            }
            PortalConfig pconfig = this.fromXML(xml, PortalConfig.class);
            this.pdcService_.create(pconfig);
        }
        catch (Exception e) {
            this.log.error((Object)(e.getMessage() + " file: " + path));
        }
    }

    private void createPage(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        boolean isTemplate = config.getTemplateOwner() != null && config.getTemplateOwner().trim().length() > 0;
        String path = this.getPathConfig(config, owner, "pages", isTemplate);
        try {
            xml = this.getDefaultConfig(config.getTemplateLocation(), path);
            if (isTemplate) {
                xml = StringUtils.replace((String)xml, (String)"@owner@", (String)owner);
            }
            Page.PageSet pageSet = this.fromXML(xml, Page.PageSet.class);
            ArrayList list = pageSet.getPages();
            for (Page page : list) {
                this.pdcService_.create(page);
            }
        }
        catch (JiBXException e) {
            this.log.error((Object)(e.getMessage() + " file: " + path));
        }
    }

    private void createPageNavigation(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        boolean isTemplate = config.getTemplateOwner() != null && config.getTemplateOwner().trim().length() > 0;
        String path = this.getPathConfig(config, owner, "navigation", isTemplate);
        try {
            PageNavigation navigation;
            xml = this.getDefaultConfig(config.getTemplateLocation(), path);
            if (isTemplate) {
                xml = StringUtils.replace((String)xml, (String)"@owner@", (String)owner);
            }
            if (this.pdcService_.getPageNavigation((navigation = this.fromXML(xml, PageNavigation.class)).getOwner()) == null) {
                this.pdcService_.create(navigation);
            } else {
                this.pdcService_.save(navigation);
            }
        }
        catch (JiBXException e) {
            this.log.error((Object)(e.getMessage() + " file: " + path));
        }
    }

    private void createGadgets(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        if (config.getTemplateOwner() == null || config.getTemplateOwner().trim().length() < 1) {
            String ownerType = config.getOwnerType();
            String path = "/" + ownerType + "/" + owner + "/" + "gadgets.xml";
            String location = config.getTemplateLocation();
            URL url = this.cmanager_.getURL(location + path);
            if (url != null) {
                xml = IOUtil.getStreamContentAsString((InputStream)this.cmanager_.getInputStream(location + path));
            }
        } else {
            String path = this.getPathConfig(config, owner, "gadgets", true);
            xml = this.getDefaultConfig(config.getTemplateLocation(), path);
            xml = StringUtils.replace((String)xml, (String)"@owner@", (String)owner);
        }
        if (xml == null) {
            return;
        }
        Gadgets gadgets = this.fromXML(xml, Gadgets.class);
        if (this.pdcService_.getGadgets(gadgets.getId()) == null) {
            this.pdcService_.create(gadgets);
        } else {
            this.pdcService_.save(gadgets);
        }
    }

    private void createPortletPreferences(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        boolean isTemplate = config.getTemplateOwner() != null && config.getTemplateOwner().trim().length() > 0;
        String path = this.getPathConfig(config, owner, "portlet-preferences", isTemplate);
        try {
            xml = this.getDefaultConfig(config.getTemplateLocation(), path);
            if (isTemplate) {
                xml = StringUtils.replace((String)xml, (String)"@owner@", (String)owner);
            }
            PortletPreferences.PortletPreferencesSet portletSet = this.fromXML(xml, PortletPreferences.PortletPreferencesSet.class);
            ArrayList list = portletSet.getPortlets();
            for (PortletPreferences portlet : list) {
                this.pdcService_.save(portlet);
            }
        }
        catch (JiBXException e) {
            this.log.error((Object)(e.getMessage() + " file: " + path));
        }
    }

    private String getDefaultConfig(String location, String path) throws Exception {
        return IOUtil.getStreamContentAsString((InputStream)this.cmanager_.getInputStream(location + path));
    }

    private String getPathConfig(NewPortalConfig portalConfig, String owner, String dataType, boolean isTemplate) {
        String path = "";
        if (isTemplate) {
            String ownerType = portalConfig.getOwnerType();
            path = "/" + ownerType + "/template/" + portalConfig.getTemplateOwner() + "/" + dataType + ".xml";
        } else {
            String ownerType = portalConfig.getOwnerType();
            path = "/" + ownerType + "/" + owner + "/" + dataType + ".xml";
        }
        return path;
    }

    public Page createPageFromTemplate(String temp) throws Exception {
        return this.fromXML(this.getTemplateConfig(temp, "page"), Page.class);
    }

    public PortletPreferences.PortletPreferencesSet createPortletPreferencesFromTemplate(String temp) throws Exception {
        return this.fromXML(this.getTemplateConfig(temp, "portlet-preferences"), PortletPreferences.PortletPreferencesSet.class);
    }

    private String getTemplateConfig(String name, String dataType) throws Exception {
        String path = this.pageTemplateConfig_.getLocation() + "/" + name + "/" + dataType + ".xml";
        InputStream is = this.cmanager_.getInputStream(path);
        return IOUtil.getStreamContentAsString((InputStream)is);
    }

    private <T> T fromXML(String xml, Class<T> clazz) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        IBindingFactory bfact = BindingDirectory.getFactory(clazz);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return clazz.cast(uctx.unmarshalDocument((InputStream)is, "UTF-8"));
    }

    String getDefaultPortal() {
        return this.defaultPortal;
    }
}

