/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;

public class NodeLocation {
    private static Log log = ExoLogger.getLogger((String)"wcm:NodeLocation");
    private String repository;
    private String workspace;
    private String path;

    public NodeLocation() {
    }

    public NodeLocation(String repository, String workspace, String path) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public static final NodeLocation parse(String exp) {
        String[] temp = exp.split("::");
        if (temp.length == 3 && temp[2].indexOf("/") > -1) {
            return new NodeLocation(temp[0], temp[1], temp[2]);
        }
        return null;
    }

    public static final NodeLocation make(Node node) {
        if (node == null) {
            return null;
        }
        try {
            Session session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            return new NodeLocation(repository, workspace, path);
        }
        catch (RepositoryException e) {
            log.error((Object)"Exception in getNodeByLocation: ", e.fillInStackTrace());
            return null;
        }
    }

    public static Node getNodeByLocation(NodeLocation nodeLocation) {
        if (nodeLocation == null) {
            return null;
        }
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            SessionProviderService sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
            ManageableRepository repository = repositoryService.getRepository(nodeLocation.getRepository());
            SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
            Session session = sessionProvider.getSession(nodeLocation.getWorkspace(), repository);
            Node node = (Node)session.getItem(nodeLocation.getPath());
            session.logout();
            sessionProvider.close();
            return node;
        }
        catch (Exception e) {
            log.error((Object)"Exception in getNodeByLocation: ", e.fillInStackTrace());
            return null;
        }
    }

    public static final String serialize(NodeLocation location) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(location.getRepository()).append("::").append(location.getWorkspace()).append("::").append(location.getPath());
        return buffer.toString();
    }
}

