/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class NewsLetterUtil {
    public static List<String> getAllGroupAndMembershipOfCurrentUser() throws Exception {
        String userId = NewsLetterUtil.getCurrentUser();
        ArrayList<String> userGroupMembership = new ArrayList<String>();
        userGroupMembership.add(userId);
        String value = "";
        String id = "";
        Membership membership = null;
        OrganizationService organizationService_ = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (Object object : organizationService_.getMembershipHandler().findMembershipsByUser(userId).toArray()) {
            id = object.toString();
            id = id.replace("Membership[", "").replace("]", "");
            membership = organizationService_.getMembershipHandler().findMembership(id);
            value = membership.getGroupId();
            userGroupMembership.add(value);
            value = membership.getMembershipType() + ":" + value;
            userGroupMembership.add(value);
        }
        return userGroupMembership;
    }

    public static void updateAccessPermission(String[] accessPermissions, UIComponent component) throws Exception {
        UserPortalConfigService userService = (UserPortalConfigService)component.getApplicationComponent(UserPortalConfigService.class);
        Page page = userService.getPage(Util.getUIPortal().getSelectedNode().getPageReference());
        ArrayList<String> listAccess = new ArrayList<String>();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)component.getApplicationComponent(WCMConfigurationService.class);
        String editSitePermission = Util.getUIPortal().getEditPermission();
        String redactorMembershipType = wcmConfigurationService.getRuntimeContextParam("redactorMembershipType");
        String groupName = null;
        if (editSitePermission.indexOf(":") != -1) {
            groupName = editSitePermission.substring(editSitePermission.indexOf(":") + 1);
        }
        OrganizationService organizationService = (OrganizationService)component.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
        Group group = organizationService.getGroupHandler().findGroupById(groupName);
        MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(redactorMembershipType);
        UserHandler userHandler = organizationService.getUserHandler();
        listAccess.addAll(Arrays.asList(page.getAccessPermissions()));
        List userViewAdminToolBar = NewsLetterUtil.getUserPermission((String[])new String[]{editSitePermission});
        for (String acc : accessPermissions) {
            if (listAccess.contains(acc)) continue;
            for (String uid : NewsLetterUtil.getUserPermission((String[])new String[]{acc})) {
                if (userViewAdminToolBar.contains(uid)) continue;
                userViewAdminToolBar.add(uid);
                memberShipHandler.linkMembership(userHandler.findUserByName(uid), group, membershipType, true);
            }
            listAccess.add(acc);
        }
        page.setAccessPermissions(listAccess.toArray(new String[0]));
        userService.update(page);
    }

    public static String getPortalName() {
        UIPortal portal = Util.getUIPortal();
        return portal.getName();
    }

    public static String generateLink(String url) {
        String link = url.replaceFirst("Subcribe", "ConfirmUserCode").replaceFirst("UINewsletterViewerForm", "UINewsletterViewerPortlet").replaceAll("&amp;", "&");
        String selectedNode = Util.getUIPortal().getSelectedNode().getUri();
        String portalName = "/" + Util.getUIPortal().getName();
        if (link.indexOf(portalName) > 0 && link.indexOf(portalName + "/" + selectedNode) < 0) {
            link = link.replaceFirst(portalName, portalName + "/" + selectedNode);
        }
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        url = portalContext.getRequest().getRequestURL().toString();
        url = url.replaceFirst("http://", "");
        url = url.substring(0, url.indexOf("/"));
        link = "http://" + url + link;
        return link.replaceFirst("private", "public");
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static boolean isModeratorOfCategory(NewsletterCategoryConfig categoryConfig) throws Exception {
        List<String> listModerators = Arrays.asList(categoryConfig.getModerator().split(","));
        if (listModerators.contains("any")) {
            return true;
        }
        for (String str : NewsLetterUtil.getAllGroupAndMembershipOfCurrentUser()) {
            if (!listModerators.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getUserPermission(String[] userGroupMembership) throws Exception {
        ArrayList<String> users = new ArrayList<String>();
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership.length == 1 && userGroupMembership[0].equals(" ")) {
            return users;
        }
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (String str : userGroupMembership) {
            if ((str = str.trim()).indexOf("/") >= 0) {
                if (str.indexOf(":") >= 0) {
                    String[] array = str.split(":");
                    List userList = organizationService.getUserHandler().findUsersByGroup(array[1]).getAll();
                    if (array[0].length() > 1) {
                        block1: for (User user : userList) {
                            if (users.contains(user.getUserName())) continue;
                            Collection memberships = organizationService.getMembershipHandler().findMembershipsByUser(user.getUserName());
                            for (Membership member : memberships) {
                                if (!member.getMembershipType().equals(array[0])) continue;
                                users.add(user.getUserName());
                                continue block1;
                            }
                        }
                        continue;
                    }
                    if (array[0].charAt(0) != '*') continue;
                    for (User user : userList) {
                        if (users.contains(user.getUserName())) continue;
                        users.add(user.getUserName());
                    }
                    continue;
                }
                List userList = organizationService.getUserHandler().findUsersByGroup(str).getAll();
                for (User user : userList) {
                    if (users.contains(user.getUserName())) continue;
                    users.add(user.getUserName());
                }
                continue;
            }
            if (users.contains(str)) continue;
            users.add(str);
        }
        return users;
    }
}

