/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UICategories;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/newsletter/NewsletterManager/UICategories.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={AddSubcriptionActionListener.class}), @EventConfig(listeners={ManagerUsersActionListener.class}), @EventConfig(listeners={SelectSubscriptionActionListener.class})})
public class UICategories
extends UIContainer {
    NewsletterCategoryHandler categoryHandler = null;
    NewsletterSubscriptionHandler subscriptionHandler = null;
    NewsletterManageUserHandler userHandler = null;
    String portalName;
    boolean isAdmin = false;

    public UICategories() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.categoryHandler = newsletterManagerService.getCategoryHandler();
        this.subscriptionHandler = newsletterManagerService.getSubscriptionHandler();
        this.userHandler = newsletterManagerService.getManageUserHandler();
        this.portalName = NewsLetterUtil.getPortalName();
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    private long getNumberOfWaitingNewsletter(String categoryName, String subscriptionName) {
        try {
            return this.subscriptionHandler.getNumberOfNewslettersWaiting(Utils.getSessionProvider(), this.portalName, categoryName, subscriptionName);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private int getNumberOfUser(String categoryName, String subscriptionName) {
        return this.userHandler.getQuantityUserBySubscription(Utils.getSessionProvider(), this.portalName, categoryName, subscriptionName);
    }

    private List<NewsletterCategoryConfig> getListCategories() {
        List<Object> listCategories = new ArrayList<NewsletterCategoryConfig>();
        try {
            String portalName = NewsLetterUtil.getPortalName();
            listCategories = this.isAdmin ? this.categoryHandler.getListCategories(portalName, Utils.getSessionProvider()) : this.categoryHandler.getListCategoriesCanView(portalName, NewsLetterUtil.getCurrentUser(), Utils.getSessionProvider());
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UICategories.msg.get-list-categories", null, (int)0);
        }
        return listCategories;
    }

    private List<NewsletterSubscriptionConfig> getListSubscription(String categoryName) {
        List<Object> listSubscription = new ArrayList<NewsletterSubscriptionConfig>();
        try {
            listSubscription = this.isAdmin || NewsLetterUtil.isModeratorOfCategory((NewsletterCategoryConfig)this.categoryHandler.getCategoryByName(Utils.getSessionProvider(), this.portalName, categoryName)) ? this.subscriptionHandler.getSubscriptionsByCategory(Utils.getSessionProvider(), NewsLetterUtil.getPortalName(), categoryName) : this.subscriptionHandler.getSubscriptionByRedactor(this.portalName, categoryName, NewsLetterUtil.getCurrentUser(), Utils.getSessionProvider());
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UICategories.msg.get-list-subscriptions", null, (int)0);
        }
        return listSubscription;
    }
}

