/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UISubcriptionForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NameValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/newsletter/NewsletterManager/UISubcriptionForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISubcriptionForm
extends UIForm {
    private static final String INPUT_SUBCRIPTION_NAME = "SubcriptionName";
    private static final String INPUT_SUBCRIPTION_DESCRIPTION = "SubcriptionDescription";
    private static final String INPUT_SUBCRIPTION_TITLE = "SubcriptionTitle";
    private static final String SELECT_CATEGORIES_NAME = "CategoryName";
    private NewsletterCategoryHandler categoryHandler = null;
    private NewsletterSubscriptionConfig subscriptionConfig = null;

    public UISubcriptionForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
        List categories = this.getListCategories();
        ArrayList<SelectItemOption> listCategoriesName = new ArrayList<SelectItemOption>();
        SelectItemOption option = null;
        for (NewsletterCategoryConfig category : categories) {
            option = new SelectItemOption(category.getTitle(), (Object)category.getName());
            listCategoriesName.add(option);
        }
        UIFormStringInput inputSubcriptionName = new UIFormStringInput(INPUT_SUBCRIPTION_NAME, null);
        inputSubcriptionName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(NameValidator.class, new Object[0]);
        UIFormStringInput inputSubcriptionTitle = new UIFormStringInput(INPUT_SUBCRIPTION_TITLE, null);
        inputSubcriptionTitle.addValidator(MandatoryValidator.class, new Object[0]);
        this.addChild((UIComponent)new UIFormSelectBox(SELECT_CATEGORIES_NAME, SELECT_CATEGORIES_NAME, listCategoriesName));
        this.addChild((UIComponent)inputSubcriptionName);
        this.addChild((UIComponent)inputSubcriptionTitle);
        this.addChild((UIComponent)new UIFormTextAreaInput(INPUT_SUBCRIPTION_DESCRIPTION, null, null));
    }

    public void setSubscriptionInfor(NewsletterSubscriptionConfig subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
        UIFormStringInput inputName = (UIFormStringInput)this.getChildById(INPUT_SUBCRIPTION_NAME);
        inputName.setValue((Object)subscriptionConfig.getName());
        inputName.setEditable(false);
        ((UIFormStringInput)this.getChildById(INPUT_SUBCRIPTION_TITLE)).setValue((Object)subscriptionConfig.getTitle());
        ((UIFormTextAreaInput)this.getChildById(INPUT_SUBCRIPTION_DESCRIPTION)).setValue((Object)subscriptionConfig.getDescription());
        UIFormSelectBox formSelectBox = (UIFormSelectBox)this.getChildById(SELECT_CATEGORIES_NAME);
        formSelectBox.setValue(subscriptionConfig.getCategoryName());
        formSelectBox.setDisabled(true);
    }

    private List<NewsletterCategoryConfig> getListCategories() {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.categoryHandler = newsletterManagerService.getCategoryHandler();
        try {
            return this.categoryHandler.getListCategories(NewsLetterUtil.getPortalName(), Utils.getSessionProvider((UIComponent)this));
        }
        catch (Exception e) {
            return new ArrayList<NewsletterCategoryConfig>();
        }
    }

    static /* synthetic */ NewsletterSubscriptionConfig access$000(UISubcriptionForm x0) {
        return x0.subscriptionConfig;
    }
}

