/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UISubscriptions;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/newsletter/NewsletterManager/UISubscriptions.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={BackToCategoriesActionListener.class}), @EventConfig(listeners={AddSubcriptionActionListener.class}), @EventConfig(listeners={EditSubscriptionActionListener.class}), @EventConfig(listeners={DeleteSubscriptionActionListener.class}, confirm="UISubscription.msg.confirmDeleteSubscription"), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UISubscription.msg.confirmDeleteCategory"), @EventConfig(listeners={OpenSubscriptionActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={ManagerUsersActionListener.class}), @EventConfig(listeners={SelectSubscriptionActionListener.class})})
public class UISubscriptions
extends UIForm {
    boolean isAdmin = false;
    boolean isModerator = false;
    NewsletterSubscriptionHandler subscriptionHandler;
    NewsletterCategoryHandler categoryHandler;
    NewsletterCategoryConfig categoryConfig;
    NewsletterManageUserHandler userHandler = null;
    String portalName;

    public UISubscriptions() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.subscriptionHandler = newsletterManagerService.getSubscriptionHandler();
        this.categoryHandler = newsletterManagerService.getCategoryHandler();
        this.userHandler = newsletterManagerService.getManageUserHandler();
        this.portalName = NewsLetterUtil.getPortalName();
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setCategory(NewsletterCategoryConfig categoryConfig) {
        this.categoryConfig = categoryConfig;
        if (!this.isAdmin) {
            try {
                this.isModerator = NewsLetterUtil.isModeratorOfCategory((NewsletterCategoryConfig)categoryConfig);
            }
            catch (Exception ex) {
                this.isModerator = false;
            }
        }
    }

    private void init(List<NewsletterSubscriptionConfig> listSubScritpions) {
        this.getChildren().clear();
        UIFormCheckBoxInput checkBoxInput = null;
        for (NewsletterSubscriptionConfig subscription : listSubScritpions) {
            checkBoxInput = new UIFormCheckBoxInput(subscription.getName(), subscription.getName(), (Object)false);
            this.addChild((UIComponent)checkBoxInput);
        }
    }

    private int getNumberOfUser(String subscriptionName) {
        return this.userHandler.getQuantityUserBySubscription(Utils.getSessionProvider(), this.portalName, this.categoryConfig.getName(), subscriptionName);
    }

    private List<NewsletterSubscriptionConfig> getListSubscription() {
        List<Object> listSubs = new ArrayList<NewsletterSubscriptionConfig>();
        try {
            listSubs = this.isAdmin || this.isModerator ? this.subscriptionHandler.getSubscriptionsByCategory(Utils.getSessionProvider(), NewsLetterUtil.getPortalName(), this.categoryConfig.getName()) : this.subscriptionHandler.getSubscriptionByRedactor(NewsLetterUtil.getPortalName(), this.categoryConfig.getName(), NewsLetterUtil.getCurrentUser(), Utils.getSessionProvider());
            this.init(listSubs);
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UISubscription.msg.get-list-subscriptions", null, (int)0);
        }
        return listSubs;
    }

    private long getNumberOfWaitingNewsletter(String subscriptionName) {
        try {
            return this.subscriptionHandler.getNumberOfNewslettersWaiting(Utils.getSessionProvider(), this.portalName, this.categoryConfig.getName(), subscriptionName);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public String getChecked() {
        String subscriptionId = null;
        UIFormCheckBoxInput checkbox = null;
        for (UIComponent component : this.getChildren()) {
            try {
                checkbox = (UIFormCheckBoxInput)component;
                if (!checkbox.isChecked()) continue;
                if (subscriptionId == null) {
                    subscriptionId = checkbox.getName();
                    continue;
                }
                return null;
            }
            catch (Exception e) {
            }
        }
        return subscriptionId;
    }
}

