/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.search.UIWCMSearchPortlet;
import org.exoplatform.wcm.webui.search.config.UISearchPageLayoutManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/search/config/UISearchPageLayoutManager.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectBasePathActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UISearchPageLayoutManager
extends UIForm
implements UISelectable {
    public static final String PORTLET_NAME = "WCM Advance Search".intern();
    public static final String SEARCH_PAGE_LAYOUT_CATEGORY = "search-page-layout".intern();
    public static final String SEARCH_PAGE_LAYOUT_SELECTOR = "searchPageLayoutSelector".intern();
    public static final String SEARCH_FORM_TEMPLATE_CATEGORY = "search-form".intern();
    public static final String SEARCH_PAGINATOR_TEMPLATE_CATEGORY = "search-paginator";
    public static final String SEARCH_RESULT_TEMPLATE_CATEGORY = "search-result";
    public static final String SEARCH_FORM_TEMPLATE_SELECTOR = "searchFormSelector";
    public static final String SEARCH_PAGINATOR_TEMPLATE_SELECTOR = "searchPaginatorSelector";
    public static final String SEARCH_RESULT_TEMPLATE_SELECTOR = "searchResultSelector";
    public static final String ITEMS_PER_PAGE_SELECTOR = "itemsPerPageSelector";
    public static final String BASE_PATH_INPUT = "searchResultBasePathInput";
    public static final String BASE_PATH_SELECTOR_POPUP_WINDOW = "searchResultBasePathPopupWindow";
    public static final String BASE_PATH_INPUT_SET_ACTION = "searchResultBasePathInputSetAction";
    private String popupId;

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public UISearchPageLayoutManager() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        String itemsPerpage = portletPreferences.getValue("itemsPerPage", null);
        String searchFormTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_FORM_TEMPLATE_PATH, null);
        String searchResultTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_RESULT_TEMPLATE_PATH, null);
        String searchPaginatorTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_PAGINATOR_TEMPLATE_PATH, null);
        String searchPageLayoutTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_PAGE_LAYOUT_TEMPLATE_PATH, null);
        List searchFormTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_FORM_TEMPLATE_CATEGORY);
        List searchResultTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_RESULT_TEMPLATE_CATEGORY);
        List searchPaginatorTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_PAGINATOR_TEMPLATE_CATEGORY);
        List searchPageLayoutTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_PAGE_LAYOUT_CATEGORY);
        ArrayList<SelectItemOption> itemsPerPageList = new ArrayList<SelectItemOption>();
        itemsPerPageList.add(new SelectItemOption("5", (Object)"5"));
        itemsPerPageList.add(new SelectItemOption("10", (Object)"10"));
        itemsPerPageList.add(new SelectItemOption("20", (Object)"20"));
        UIFormSelectBox itemsPerPageSelector = new UIFormSelectBox(ITEMS_PER_PAGE_SELECTOR, ITEMS_PER_PAGE_SELECTOR, itemsPerPageList);
        UIFormSelectBox searchFormTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_FORM_TEMPLATE_SELECTOR, SEARCH_FORM_TEMPLATE_SELECTOR, searchFormTemplateList).setRendered(false);
        UIFormSelectBox searchResultTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_RESULT_TEMPLATE_SELECTOR, SEARCH_RESULT_TEMPLATE_SELECTOR, searchResultTemplateList).setRendered(false);
        UIFormSelectBox searchPaginatorTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_PAGINATOR_TEMPLATE_SELECTOR, SEARCH_PAGINATOR_TEMPLATE_SELECTOR, searchPaginatorTemplateList).setRendered(false);
        UIFormSelectBox searchPageLayoutTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_PAGE_LAYOUT_SELECTOR, SEARCH_PAGE_LAYOUT_SELECTOR, searchPageLayoutTemplateList).setRendered(false);
        String preferenceBasePath = portletPreferences.getValue("basePath", null);
        UIFormInputSetWithAction targetPathFormInputSet = new UIFormInputSetWithAction(BASE_PATH_INPUT_SET_ACTION);
        UIFormStringInput targetPathFormStringInput = new UIFormStringInput(BASE_PATH_INPUT, BASE_PATH_INPUT, preferenceBasePath);
        targetPathFormStringInput.setValue((Object)preferenceBasePath);
        targetPathFormStringInput.setEditable(false);
        targetPathFormInputSet.setActionInfo(BASE_PATH_INPUT, new String[]{"SelectBasePath"});
        targetPathFormInputSet.addUIFormInput((UIFormInput)targetPathFormStringInput);
        itemsPerPageSelector.setValue(itemsPerpage);
        searchFormTemplateSelector.setValue(searchFormTemplate);
        searchResultTemplateSelector.setValue(searchResultTemplate);
        searchPaginatorTemplateSelector.setValue(searchPaginatorTemplate);
        searchPageLayoutTemplateSelector.setValue(searchPageLayoutTemplate);
        this.addChild((UIComponent)itemsPerPageSelector);
        this.addChild((UIComponent)searchFormTemplateSelector);
        this.addChild((UIComponent)searchResultTemplateSelector);
        this.addChild((UIComponent)searchPaginatorTemplateSelector);
        this.addChild((UIComponent)searchPageLayoutTemplateSelector);
        this.addChild((UIComponent)targetPathFormInputSet);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private List<SelectItemOption<String>> createTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodeList = templateManagerService.getTemplatesByCategory(repository, portletName, category, Utils.getSessionProvider());
        for (Node templateNode : templateNodeList) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templateList.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templateList;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)((String)value));
        Utils.closePopupWindow((UIContainer)this, (String)this.popupId);
    }
}

