/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.wcm.webui.selector.UISelectPathPanel;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.wcm.webui.selector.content.UIContentTreeNode;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/wcm/webui/selector/content/UIContentTreeBuilder.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIContentTreeBuilder
extends UIContainer {
    public List<String> path = new ArrayList<String>();
    protected String repositoryName;

    public boolean isSymLink(Node node) throws Exception {
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    private List<DriveData> getDrives(RepositoryService repositoryService) throws Exception {
        String[] allPermission;
        String repoName = repositoryService.getDefaultRepository().getConfiguration().getName();
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        List allDrives = driveService.getAllDrives(repoName);
        HashSet<DriveData> temp = new HashSet<DriveData>();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId != null) {
            block0: for (DriveData driveData : allDrives) {
                allPermission = driveData.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : Utils.getMemberships()) {
                        if (!driveData.hasPermission(allPermission, rolse)) continue;
                        temp.add(driveData);
                        continue block1;
                    }
                }
            }
        } else {
            block3: for (DriveData driveData : allDrives) {
                for (String permission : allPermission = driveData.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    temp.add(driveData);
                    continue block3;
                }
            }
        }
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            driveList.add((DriveData)iterator.next());
        }
        Collections.sort(driveList);
        return driveList;
    }

    private List<DriveData> personalDrives(NodeHierarchyCreator nodeHierarchyCreator, List<DriveData> driveList) {
        ArrayList<DriveData> personalDrives = new ArrayList<DriveData>();
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String currentUser = Util.getPortalRequestContext().getRemoteUser();
        for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(userPath + "/${userId}/")) continue;
            drive.setHomePath(drive.getHomePath().replace("${userId}", currentUser));
            personalDrives.add(drive);
        }
        Collections.sort(personalDrives);
        return personalDrives;
    }

    private List<DriveData> groupDrives(NodeHierarchyCreator nodeHierarchyCreator, List<DriveData> driveList) throws Exception {
        ArrayList<DriveData> groupDrives = new ArrayList<DriveData>();
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        List groups = Utils.getGroups();
        block0: for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrives.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrives);
        return groupDrives;
    }

    private List<DriveData> generalDrives(NodeHierarchyCreator nodeHierarchyCreator, List<DriveData> driveList) throws Exception {
        ArrayList<DriveData> generalDrives = new ArrayList<DriveData>();
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driveList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrives.add(drive);
        }
        return generalDrives;
    }

    protected Session getSession(String workSpaceName) throws Exception {
        return SessionProviderFactory.createSessionProvider().getSession(workSpaceName, ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getDefaultRepository());
    }

    private void addTreeFromDrives(SessionProvider sessionProvider, ManageableRepository manageableRepository, String path, List<UIContentTreeNode> list, List<DriveData> listDris) throws Exception {
        Session session = null;
        String workSpace = null;
        for (DriveData dri : listDris) {
            try {
                if (!dri.getWorkspace().equals(workSpace)) {
                    if (session != null) {
                        session.logout();
                    }
                    session = sessionProvider.getSession(dri.getWorkspace(), manageableRepository);
                    workSpace = dri.getWorkspace();
                }
                list.add(new UIContentTreeNode(path, dri.getName(), dri.getWorkspace(), (Node)session.getItem(dri.getHomePath()), 1));
            }
            catch (Exception ex) {}
        }
        if (session != null) {
            session.logout();
        }
    }

    private void addRootDrives(List<UIContentTreeNode> list) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        List<DriveData> listDris = this.getDrives(repositoryService);
        ManageableRepository manageableRepository = repositoryService.getDefaultRepository();
        this.repositoryName = manageableRepository.getConfiguration().getName();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        list.add(new UIContentTreeNode("General Drives"));
        this.addTreeFromDrives(sessionProvider, manageableRepository, "/General Drives", list, this.generalDrives(nodeHierarchyCreator, listDris));
        list.add(new UIContentTreeNode("Group Drives"));
        this.addTreeFromDrives(sessionProvider, manageableRepository, "/Group Drives", list, this.groupDrives(nodeHierarchyCreator, listDris));
        list.add(new UIContentTreeNode("Personal Drives"));
        this.addTreeFromDrives(sessionProvider, manageableRepository, "/Personal Drives", list, this.personalDrives(nodeHierarchyCreator, listDris));
        sessionProvider.close();
    }

    public List<UIContentTreeNode> getTreeNode() throws Exception {
        ArrayList<UIContentTreeNode> list = new ArrayList<UIContentTreeNode>();
        this.addRootDrives(list);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIContentTreeBuilder> {
        public void execute(Event<UIContentTreeBuilder> event) throws Exception {
            UIContentTreeBuilder contentTreeBuilder = (UIContentTreeBuilder)((Object)event.getSource());
            String values = event.getRequestContext().getRequestParameter("objectId");
            String path = values.substring(values.lastIndexOf("/") + 1);
            while (!contentTreeBuilder.path.isEmpty()) {
                if (path.contains(contentTreeBuilder.path.get(contentTreeBuilder.path.size() - 1) + "rp")) {
                    contentTreeBuilder.path.add(path);
                    break;
                }
                contentTreeBuilder.path.remove(contentTreeBuilder.path.size() - 1);
            }
            if (contentTreeBuilder.path.isEmpty()) {
                contentTreeBuilder.path.add(path);
            }
            values = values.substring(0, values.lastIndexOf("/"));
            String workSpaceName = values.substring(values.lastIndexOf("/") + 1);
            String nodePath = values.substring(0, values.lastIndexOf("/"));
            ManageableRepository manageableRepository = ((RepositoryService)contentTreeBuilder.getApplicationComponent(RepositoryService.class)).getDefaultRepository();
            SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
            Session session = sessionProvider.getSession(workSpaceName, manageableRepository);
            Node rootNode = (Node)session.getItem(nodePath);
            UISelectPathPanel selectPathPanel = (UISelectPathPanel)((UIContentBrowsePanel)contentTreeBuilder.getAncestorOfType(UIContentBrowsePanel.class)).getChild(UISelectPathPanel.class);
            selectPathPanel.setParentNode(rootNode);
            selectPathPanel.updateGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)selectPathPanel);
            session.logout();
            sessionProvider.close();
            UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)Util.getUIPortalApplication().getChild(UIMaskWorkspace.class);
            if (maskWorkspace != null) {
                maskWorkspace.setUpdated(false);
            }
        }
    }
}

