/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.XMLOutputTransformer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/wcmTreeContent/")
public class UpdateTreeConnector
implements ResourceContainer {
    public static final String FILE_TYPE_WEBCONTENT = "Web Contents";
    public static final String FILE_TYPE_DMSDOC = "DMS Documents";
    public static final String FILE_TYPE_MEDIAS = "Medias";
    private static Log log = ExoLogger.getLogger(UpdateTreeConnector.class);
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    @HTTPMethod(value="GET")
    @URITemplate(value="/getChildNodes/")
    @OutputTransformer(value=XMLOutputTransformer.class)
    public Response getChildNodes(@QueryParam(value="nodePath") String nodePath, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="repositoryName") String repositoryName) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        try {
            SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            Node node = (Node)session.getItem(nodePath);
            NodeIterator nodeIterator = node.getNodes();
            int index = 0;
            Element parentNode = document.createElement("childNodes");
            document.appendChild(parentNode);
            while (nodeIterator.hasNext()) {
                node = nodeIterator.nextNode();
                if (this.isDocumentType(node, repositoryName) || node.isNodeType("exo:hiddenable") || !node.isNodeType("exo:taxonomy") && !node.isNodeType("nt:unstructured") && !node.isNodeType("nt:folder")) continue;
                StringBuilder buffer = new StringBuilder(128);
                buffer.append(node.getName());
                index = node.getIndex();
                if (index > 1) {
                    buffer.append('[');
                    buffer.append(index);
                    buffer.append(']');
                }
                Element childNode = document.createElement("childNode");
                parentNode.appendChild(childNode);
                Element workSpaceEle = document.createElement("workspaceName");
                workSpaceEle.setTextContent(workspaceName);
                Element repositoryEle = document.createElement("repositoryName");
                repositoryEle.setTextContent(repositoryName);
                Element nameEle = document.createElement("name");
                nameEle.setTextContent(buffer.toString());
                Element nodePathEle = document.createElement("nodePath");
                nodePathEle.setTextContent(node.getPath());
                childNode.appendChild(workSpaceEle);
                childNode.appendChild(repositoryEle);
                childNode.appendChild(nameEle);
                childNode.appendChild(nodePathEle);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.Builder.ok((Object)document).header(LAST_MODIFIED_PROPERTY, dateFormat.format(new Date())).mediaType("text/xml").cacheControl(cacheControl).build();
    }

    private List<DriveData> getDriversByUserId(String repoName, String userId) throws Exception {
        String[] allPermission;
        ManageDriveService driveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        List<String> userRoles = UpdateTreeConnector.getMemberships(userId);
        List allDrives = driveService.getAllDrives(repoName);
        HashSet<DriveData> temp = new HashSet<DriveData>();
        if (userId != null) {
            block0: for (DriveData driveData : allDrives) {
                allPermission = driveData.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : userRoles) {
                        if (!driveData.hasPermission(allPermission, rolse)) continue;
                        temp.add(driveData);
                        continue block1;
                    }
                }
            }
        } else {
            block3: for (DriveData driveData : allDrives) {
                for (String permission : allPermission = driveData.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    temp.add(driveData);
                    continue block3;
                }
            }
        }
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            driveList.add((DriveData)iterator.next());
        }
        Collections.sort(driveList);
        return driveList;
    }

    private Element appendDrivers(Document document, List<DriveData> driversList, String groupName) {
        Element folders = document.createElement("Folders");
        folders.setAttribute("name", groupName);
        for (DriveData driver : driversList) {
            Element folder = document.createElement("Folder");
            folder.setAttribute("name", driver.getName());
            folder.setAttribute("driverPath", driver.getHomePath());
            folders.appendChild(folder);
        }
        return folders;
    }

    private List<DriveData> personalDrivers(List<DriveData> driveList) {
        ArrayList<DriveData> personalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(userPath + "/${userId}/")) continue;
            personalDrivers.add(drive);
        }
        Collections.sort(personalDrivers);
        return personalDrivers;
    }

    private List<DriveData> groupDrivers(List<DriveData> driverList, String userId) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        ArrayList<DriveData> groupDrivers = new ArrayList<DriveData>();
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        List<String> groups = UpdateTreeConnector.getGroups(userId);
        block0: for (DriveData drive : driverList) {
            if (!drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrivers.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrivers);
        return groupDrivers;
    }

    private List<DriveData> generalDrivers(List<DriveData> driverList) throws Exception {
        ArrayList<DriveData> generalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driverList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrivers.add(drive);
        }
        return generalDrivers;
    }

    private static List<String> getMemberships(String userId) throws Exception {
        OrganizationService oservice = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection memberships = oservice.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Membership membership = (Membership)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroupId();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    private static List<String> getGroups(String userId) throws Exception {
        OrganizationService oservice = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ArrayList<String> groupList = new ArrayList<String>();
        Collection groups = oservice.getGroupHandler().findGroupsOfUser(userId);
        Object[] objects = groups.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Group group = (Group)objects[i];
            String groupPath = null;
            groupPath = group.getParentId() == null || group.getParentId().length() == 0 ? "/" + group.getGroupName() : group.getParentId() + "/" + group.getGroupName();
            groupList.add(groupPath);
        }
        return groupList;
    }

    private boolean isDMSDocument(Node node, String repositoryName) throws Exception {
        TemplateService templateService = (TemplateService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TemplateService.class);
        List dmsDocumentList = templateService.getDocumentTemplates(repositoryName);
        dmsDocumentList.remove("exo:webContent");
        for (String documentType : dmsDocumentList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return true;
        }
        return false;
    }

    private boolean isDocumentType(Node node, String repoName) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        List documentList = templateService.getAllDocumentNodeTypes(repoName);
        for (String documentType : documentList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return true;
        }
        return false;
    }
}

