/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.webcontent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.webcontent.UIWCMSearchResult;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentTabSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/UIWebContentSearchForm.gtmpl", events={@EventConfig(listeners={SearchWebContentActionListener.class}), @EventConfig(listeners={AddMetadataTypeActionListener.class}), @EventConfig(listeners={AddNodeTypeActionListener.class})})
public class UIWebContentSearchForm
extends UIForm {
    public static final String LOCATION = "location".intern();
    public static final String SEARCH_BY_NAME = "name".intern();
    public static final String SEARCH_BY_CONTENT = "content".intern();
    public static final String RADIO_NAME = "WcmRadio".intern();
    public static final String TIME_OPTION = "timeOpt";
    public static final String PROPERTY = "property";
    public static final String CONTAIN = "contain";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String DOC_TYPE = "docType";
    public static final String CATEGORY = "category";
    public static final String CREATED_DATE = "CREATED";
    public static final String MODIFIED_DATE = "MODIFIED";
    public static final String EXACTLY_PROPERTY = "exactlyPro";
    public static final String CONTAIN_PROPERTY = "containPro";
    public static final String NOT_CONTAIN_PROPERTY = "notContainPro";
    public static final String DATE_PROPERTY = "datePro";
    public static final String NODETYPE_PROPERTY = "nodetypePro";
    public static final String CHECKED_RADIO_ID = "checkedRadioId".intern();
    private String checkedRadioId;

    public void init() throws Exception {
        ArrayList<SelectItemOption> portalNameOptions = new ArrayList<SelectItemOption>();
        List<String> portalNames = this.getPortalNames();
        for (String portalName : portalNames) {
            portalNameOptions.add(new SelectItemOption(portalName, (Object)portalName));
        }
        UIFormSelectBox portalNameSelectBox = new UIFormSelectBox(LOCATION, LOCATION, portalNameOptions);
        portalNameSelectBox.setDefaultValue((Object)portalNames.get(0));
        this.addChild((UIComponent)portalNameSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_BY_NAME, SEARCH_BY_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_BY_CONTENT, SEARCH_BY_CONTENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PROPERTY, PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTAIN, CONTAIN, null));
        ArrayList<SelectItemOption> dateOptions = new ArrayList<SelectItemOption>();
        dateOptions.add(new SelectItemOption(CREATED_DATE, (Object)CREATED_DATE));
        dateOptions.add(new SelectItemOption(MODIFIED_DATE, (Object)MODIFIED_DATE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIME_OPTION, TIME_OPTION, dateOptions));
        UIFormDateTimeInput startTime = new UIFormDateTimeInput(START_TIME, START_TIME, null, true);
        this.addUIFormInput((UIFormInput)startTime);
        UIFormDateTimeInput endTime = new UIFormDateTimeInput(END_TIME, END_TIME, null, true);
        this.addUIFormInput((UIFormInput)endTime);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DOC_TYPE, DOC_TYPE, null));
        this.setActions(new String[]{"SearchWebContent"});
    }

    private List<String> getPortalNames() throws Exception {
        ArrayList<String> portalNames = new ArrayList<String>();
        String currentPortalName = Util.getUIPortal().getName();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = repoService.getCurrentRepository().getConfiguration().getName();
        WCMConfigurationService configService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String sharedPortalName = configService.getSharedPortalName(repository);
        portalNames.add(currentPortalName);
        portalNames.add(sharedPortalName);
        return portalNames;
    }

    private PaginatedQueryResult searchWebContentByName(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(false);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        SessionProvider sessionProvider = Utils.getSessionProvider((UIComponent)this);
        WCMPaginatedQueryResult paginatedQueryResult = siteSearch.searchSiteContents(qCriteria, sessionProvider, pageSize);
        sessionProvider.close();
        return paginatedQueryResult;
    }

    private PaginatedQueryResult searchWebContentByFulltext(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(".");
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        SessionProvider sessionProvider = Utils.getSessionProvider((UIComponent)this);
        WCMPaginatedQueryResult paginatedQueryResult = siteSearch.searchSiteContents(qCriteria, sessionProvider, pageSize);
        sessionProvider.close();
        return paginatedQueryResult;
    }

    private PaginatedQueryResult searchWebContentByProperty(String property, String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(property);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        SessionProvider sessionProvider = Utils.getSessionProvider((UIComponent)this);
        WCMPaginatedQueryResult paginatedQueryResult = siteSearchService.searchSiteContents(qCriteria, sessionProvider, pageSize);
        sessionProvider.close();
        return paginatedQueryResult;
    }

    private PaginatedQueryResult searchWebContentByDate(QueryCriteria.DATE_RANGE_SELECTED dateRangeSelected, Calendar fromDate, Calendar endDate, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setDateRangeSelected(dateRangeSelected);
        QueryCriteria.DatetimeRange dateTimeRange = new QueryCriteria.DatetimeRange(fromDate, endDate);
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED.equals((Object)dateRangeSelected)) {
            qCriteria.setCreatedDateRange(dateTimeRange);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED.equals((Object)dateRangeSelected)) {
            qCriteria.setLastModifiedDateRange(dateTimeRange);
        }
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        SessionProvider sessionProvider = Utils.getSessionProvider((UIComponent)this);
        WCMPaginatedQueryResult paginatedQueryResult = siteSearch.searchSiteContents(qCriteria, sessionProvider, pageSize);
        sessionProvider.close();
        return paginatedQueryResult;
    }

    private PaginatedQueryResult searchWebContentByDocumentType(String documentType, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        qCriteria.setContentTypes(documentType.split(","));
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        SessionProvider sessionProvider = Utils.getSessionProvider((UIComponent)this);
        WCMPaginatedQueryResult paginatedQueryResult = siteSearch.searchSiteContents(qCriteria, sessionProvider, pageSize);
        sessionProvider.close();
        return paginatedQueryResult;
    }

    private QueryCriteria getInitialQueryCriteria(String siteName) {
        QueryCriteria qCriteria = new QueryCriteria();
        qCriteria.setSearchDocument(false);
        qCriteria.setSearchWebpage(false);
        qCriteria.setSearchWebContent(true);
        qCriteria.setSiteName(siteName);
        qCriteria.setLiveMode(false);
        return qCriteria;
    }

    private boolean haveEmptyField(UIApplication uiApp, Event<UIWebContentSearchForm> event, Object ... fields) throws Exception {
        for (Object field : fields) {
            if (field != null) continue;
            uiApp.addMessage(new ApplicationMessage("UIWebContentSearchForm.empty-field", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return true;
        }
        return false;
    }

    public String getCheckedRadioId() {
        return this.checkedRadioId;
    }

    public void setCheckedRadioId(String checkedRadioId) {
        this.checkedRadioId = checkedRadioId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchWebContentActionListener
    extends EventListener<UIWebContentSearchForm> {
        public void execute(Event<UIWebContentSearchForm> event) throws Exception {
            String keyword;
            UIWebContentSearchForm uiWCSearch = (UIWebContentSearchForm)((Object)event.getSource());
            String radioValue = event.getRequestContext().getRequestParameter(RADIO_NAME);
            String siteName = (String)uiWCSearch.getUIStringInput(LOCATION).getValue();
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiWCSearch.getParent();
            UIApplication uiApp = (UIApplication)uiWCSearch.getAncestorOfType(UIApplication.class);
            QueryCriteria qCriteria = uiWCSearch.getInitialQueryCriteria(siteName);
            int pageSize = 5;
            PaginatedQueryResult pagResult = null;
            if (SEARCH_BY_NAME.equals(radioValue)) {
                keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                if (uiWCSearch.haveEmptyField(uiApp, (Event<UIWebContentSearchForm>)event, new Object[]{keyword})) {
                    return;
                }
                pagResult = uiWCSearch.searchWebContentByName(keyword, qCriteria, pageSize);
            } else if (SEARCH_BY_CONTENT.equals(radioValue)) {
                keyword = (String)uiWCSearch.getUIStringInput(radioValue).getValue();
                if (uiWCSearch.haveEmptyField(uiApp, (Event<UIWebContentSearchForm>)event, new Object[]{keyword})) {
                    return;
                }
                pagResult = uiWCSearch.searchWebContentByFulltext(keyword, qCriteria, pageSize);
            } else if (UIWebContentSearchForm.PROPERTY.equals(radioValue)) {
                String property = (String)uiWCSearch.getUIStringInput(UIWebContentSearchForm.PROPERTY).getValue();
                String keyword2 = (String)uiWCSearch.getUIStringInput(UIWebContentSearchForm.CONTAIN).getValue();
                if (uiWCSearch.haveEmptyField(uiApp, (Event<UIWebContentSearchForm>)event, new Object[]{property, keyword2})) {
                    return;
                }
                pagResult = uiWCSearch.searchWebContentByProperty(property, keyword2, qCriteria, pageSize);
            } else if (UIWebContentSearchForm.TIME_OPTION.equals(radioValue)) {
                Calendar fromDate = uiWCSearch.getUIFormDateTimeInput(UIWebContentSearchForm.START_TIME).getCalendar();
                if (uiWCSearch.haveEmptyField(uiApp, (Event<UIWebContentSearchForm>)event, new Object[]{fromDate})) {
                    return;
                }
                Calendar endDate = uiWCSearch.getUIFormDateTimeInput(UIWebContentSearchForm.END_TIME).getCalendar();
                if (endDate == null) {
                    endDate = Calendar.getInstance();
                }
                if (fromDate.getTimeInMillis() > endDate.getTimeInMillis()) {
                    uiApp.addMessage(new ApplicationMessage("UIWebContentSearchForm.invalid-date", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                String dateRangeSelected = (String)uiWCSearch.getUIStringInput(UIWebContentSearchForm.TIME_OPTION).getValue();
                pagResult = UIWebContentSearchForm.CREATED_DATE.equals(dateRangeSelected) ? uiWCSearch.searchWebContentByDate(QueryCriteria.DATE_RANGE_SELECTED.CREATED, fromDate, endDate, qCriteria, pageSize) : uiWCSearch.searchWebContentByDate(QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED, fromDate, endDate, qCriteria, pageSize);
            } else if (UIWebContentSearchForm.DOC_TYPE.equals(radioValue)) {
                String documentType = (String)uiWCSearch.getUIStringInput(UIWebContentSearchForm.DOC_TYPE).getValue();
                if (uiWCSearch.haveEmptyField(uiApp, (Event<UIWebContentSearchForm>)event, new Object[]{documentType})) {
                    return;
                }
                pagResult = uiWCSearch.searchWebContentByDocumentType(documentType, qCriteria, pageSize);
            }
            UIWCMSearchResult uiWCSearchResult = (UIWCMSearchResult)uiWCTabSelector.getChild(UIWCMSearchResult.class);
            uiWCSearchResult.updateGrid(pagResult);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
            uiWCTabSelector.setSelectedTab(uiWCSearchResult.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNodeTypeActionListener
    extends EventListener<UIWebContentSearchForm> {
        public void execute(Event<UIWebContentSearchForm> event) throws Exception {
            UIWebContentSearchForm uiWCSearchForm = (UIWebContentSearchForm)((Object)event.getSource());
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiWCSearchForm.getParent();
            uiWCSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(CHECKED_RADIO_ID));
            uiWCTabSelector.initNodeTypePopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddMetadataTypeActionListener
    extends EventListener<UIWebContentSearchForm> {
        public void execute(Event<UIWebContentSearchForm> event) throws Exception {
            UIWebContentSearchForm uiWCSearchForm = (UIWebContentSearchForm)((Object)event.getSource());
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiWCSearchForm.getParent();
            uiWCSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(CHECKED_RADIO_ID));
            uiWCTabSelector.initMetadataPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
        }
    }
}

