/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.servlet.http.HttpSession;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.lock.LockManager;

public class LockUtil {
    public static void keepLock(Lock lock) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        String key = LockUtil.createLockKey(lock.getNode());
        HashMap<String, String> lockedNodesInfo = (HashMap<String, String>)httpSession.getAttribute(LockManager.class.getName());
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(key, lock.getLockToken());
        httpSession.setAttribute(LockManager.class.getName(), lockedNodesInfo);
    }

    public static void changeLockToken(Node oldNode, Node newNode) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        String newKey = LockUtil.createLockKey(newNode);
        String oldKey = LockUtil.createLockKey(oldNode);
        HashMap<String, String> lockedNodesInfo = (HashMap<String, String>)httpSession.getAttribute(LockManager.class.getName());
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.remove(oldKey);
        lockedNodesInfo.put(newKey, newNode.getLock().getLockToken());
        httpSession.setAttribute(LockManager.class.getName(), lockedNodesInfo);
    }

    public static void changeLockToken(String srcPath, Node newNode) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        String newKey = LockUtil.createLockKey(newNode);
        String oldKey = LockUtil.getOldLockKey(srcPath, newNode);
        HashMap lockedNodesInfo = (HashMap)httpSession.getAttribute(LockManager.class.getName());
        if (lockedNodesInfo.containsKey(oldKey)) {
            lockedNodesInfo.put(newKey, lockedNodesInfo.get(oldKey));
            lockedNodesInfo.remove(oldKey);
        }
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap();
        }
        httpSession.setAttribute(LockManager.class.getName(), lockedNodesInfo);
    }

    public static String getLockToken(Node node) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        String key = LockUtil.createLockKey(node);
        Map lockedNodesInfo = (Map)httpSession.getAttribute(LockManager.class.getName());
        if (lockedNodesInfo == null) {
            return null;
        }
        return (String)lockedNodesInfo.get(key);
    }

    public static String getOldLockKey(String srcPath, Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(session.getUserID()).append(":/:").append(srcPath);
        return buffer.toString();
    }

    public static String createLockKey(Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(session.getUserID()).append(":/:").append(node.getPath());
        return buffer.toString();
    }
}

