/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.config.NewsletterManagerConfig;
import org.exoplatform.services.wcm.skin.XSkinService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterEntryHandler {
    private static Log log = ExoLogger.getLogger(NewsletterEntryHandler.class);
    private RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
    private ThreadLocalSessionProviderService threadLocalSessionProviderService;
    private String repository;
    private String workspace;

    public NewsletterEntryHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
        this.threadLocalSessionProviderService = (ThreadLocalSessionProviderService)ThreadLocalSessionProviderService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThreadLocalSessionProviderService.class));
    }

    private NewsletterManagerConfig getEntryFromNode(Node entryNode) throws Exception {
        NewsletterManagerConfig newsletterEntryConfig = new NewsletterManagerConfig();
        newsletterEntryConfig.setNewsletterName(entryNode.getName());
        if (entryNode.hasProperty("exo:title")) {
            newsletterEntryConfig.setNewsletterTitle(entryNode.getProperty("exo:title").getString());
        }
        newsletterEntryConfig.setNewsletterSentDate(entryNode.getProperty("exo:newsletterEntryDate").getDate().getTime());
        newsletterEntryConfig.setStatus(entryNode.getProperty("exo:newsletterEntryStatus").getString());
        newsletterEntryConfig.setSubcriptionName(entryNode.getParent().getName());
        newsletterEntryConfig.setCategoryName(entryNode.getParent().getParent().getName());
        return newsletterEntryConfig;
    }

    public void delete(String portalName, String categoryName, String subscriptionName, List<String> listIds) {
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProviderFactory.createSystemProvider();
        }
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName;
            Node subscriptionNode = (Node)session.getItem(path);
            Node newsletterNode = null;
            for (String id : listIds) {
                newsletterNode = subscriptionNode.getNode(id);
                newsletterNode.remove();
            }
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sessionProvider.close();
    }

    public List<NewsletterManagerConfig> getNewsletterEntriesBySubscription(String portalName, String categoryName, String subscriptionName) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProviderFactory.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterEntry where jcr:path LIKE '" + path + "[%]/%'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        ArrayList<NewsletterManagerConfig> listNewsletterEntry = new ArrayList<NewsletterManagerConfig>();
        while (nodeIterator.hasNext()) {
            try {
                listNewsletterEntry.add(this.getEntryFromNode(nodeIterator.nextNode()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        sessionProvider.close();
        return listNewsletterEntry;
    }

    public NewsletterManagerConfig getNewsletterEntry(String portalName, String categoryName, String subscriptionName, String newsletterName) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProviderFactory.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName + "/" + newsletterName;
        NewsletterManagerConfig newsletterManagerConfig = this.getEntryFromNode((Node)session.getItem(path));
        sessionProvider.close();
        return newsletterManagerConfig;
    }

    public NewsletterManagerConfig getNewsletterEntryByPath(String path) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProviderFactory.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        NewsletterManagerConfig newsletterManagerConfig = this.getEntryFromNode((Node)session.getItem(path));
        sessionProvider.close();
        return newsletterManagerConfig;
    }

    public String getContent(String portalName, String categoryName, String subscriptionName, String newsletterName) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProviderFactory.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName + "/" + newsletterName;
        Node newsletterNode = (Node)session.getItem(path);
        XSkinService xSkService = (XSkinService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(XSkinService.class);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<style type=\"text/css\">");
            sb.append(this.removeEncodedCharacter(xSkService.getActiveStylesheet(newsletterNode)));
            sb.append("</style>");
            sb.append(newsletterNode.getNode("default.html").getNode("jcr:content").getProperty("jcr:data").getString());
            sessionProvider.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return null;
        }
    }

    public String getContent(Node webContent) throws Exception {
        XSkinService xSkService = (XSkinService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(XSkinService.class);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\" dir=\"ltr\">");
            sb.append("<head>");
            sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
            sb.append("<style type=\"text/css\">");
            sb.append(this.removeEncodedCharacter(xSkService.getActiveStylesheet(webContent)));
            sb.append("</style>");
            sb.append("</head>");
            sb.append("<body>");
            sb.append(webContent.getNode("default.html").getNode("jcr:content").getProperty("jcr:data").getString());
            sb.append("</body>");
            sb.append("</html>");
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String removeEncodedCharacter(String rawString) {
        return rawString.replaceAll("\t", " ").replaceAll("\n", " ");
    }
}

