/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterPublicUserHandler {
    private static Log log = ExoLogger.getLogger(NewsletterPublicUserHandler.class);
    private RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
    private ThreadLocalSessionProviderService threadLocalSessionProviderService = (ThreadLocalSessionProviderService)ThreadLocalSessionProviderService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThreadLocalSessionProviderService.class));
    private String repository;
    private String workspace;

    public NewsletterPublicUserHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    private List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listString;
    }

    protected void updateSubscriptions(Session session, List<String> listCategorySubscription, String portalName, String userMail) throws Exception {
        ArrayList<String> subscribedUsers = new ArrayList<String>();
        String categryHomePath = NewsletterConstant.generateCategoryPath(portalName);
        for (String categoryAndSubscription : listCategorySubscription) {
            String categoryName = categoryAndSubscription.split("#")[0];
            String subscriptionName = categoryAndSubscription.split("#")[1];
            try {
                Node subscriptionNode = (Node)Node.class.cast(session.getItem(categryHomePath + "/" + categoryName + "/" + subscriptionName));
                if (subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) {
                    subscribedUsers = new ArrayList();
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    subscribedUsers.addAll(this.convertValuesToArray(subscribedUserProperty.getValues()));
                    subscribedUsers.add(userMail);
                    subscribedUserProperty.setValue(subscribedUsers.toArray(new String[0]));
                    continue;
                }
                subscriptionNode.setProperty("exo:newsletterSubscribedUser", new String[]{userMail});
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        session.save();
    }

    protected void clearEmailInSubscription(String email) {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlQuery = "select * from exo:newsletterSubscription where exo:newsletterSubscribedUser like '%" + email + "%'";
            Query query = queryManager.createQuery(sqlQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                Node subscriptionNode = nodeIterator.nextNode();
                Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                List<Value> oldSubscribedUsers = Arrays.asList(subscribedUserProperty.getValues());
                ArrayList<Value> newSubscribedUsers = new ArrayList<Value>();
                for (Value value : oldSubscribedUsers) {
                    String subscribedUserMail = value.getString();
                    if (email.equals(subscribedUserMail)) continue;
                    newSubscribedUsers.add(value);
                }
                subscribedUserProperty.setValue(newSubscribedUsers.toArray(new Value[newSubscribedUsers.size()]));
            }
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Update user's subscription for user " + email + " failed because of " + e.getMessage()));
        }
    }

    public void subscribe(String portalName, String userMail, List<String> listCategorySubscription, String link, String[] emailContent, SessionProvider sessionProvider) {
        log.info((Object)("Trying to subscribe user " + userMail));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            NewsletterManageUserHandler manageUserHandler = new NewsletterManageUserHandler(this.repository, this.workspace);
            Node userNode = manageUserHandler.add(portalName, userMail, sessionProvider);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            this.updateSubscriptions(session, listCategorySubscription, portalName, userMail);
            String openTag = "<a href=\"" + link.replaceFirst("OBJECTID", userMail + "/" + userNode.getProperty("exo:newsletterUserValidationCode").getString()) + "\">";
            String mailContent = emailContent[1].replaceFirst("#", openTag).replace("#", "</a>");
            Message message = new Message();
            message.setMimeType("text/html");
            message.setFrom("maivanha1610@gmail.com");
            message.setTo(userMail);
            message.setSubject(emailContent[0]);
            message.setBody(mailContent);
            try {
                MailService mService = (MailService)PortalContainer.getComponent(MailService.class);
                mService.sendMessage(message);
            }
            catch (Exception e) {
                MailService mService = (MailService)StandaloneContainer.getInstance().getComponentInstanceOfType(MailService.class);
                mService.sendMessage(message);
            }
        }
        catch (Exception e) {
            log.error((Object)("Subscribe user " + userMail + " failed because of " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public boolean confirmPublicUser(String Email, String userCode, String portalName) throws Exception {
        String sqlQuery;
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(sqlQuery = "select * from exo:newsletterUser where exo:newsletterUserValidationCode = '" + userCode + "' and " + "exo:newsletterUserMail" + " = '" + Email + "'", "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        return nodeIterator.hasNext();
    }

    public void forgetEmail(String portalName, String email) {
        log.info((Object)("Trying to update user's subscriptions for user " + email));
        try {
            this.clearEmailInSubscription(email);
            NewsletterManageUserHandler manageUserHandler = new NewsletterManageUserHandler(this.repository, this.workspace);
            manageUserHandler.delete(portalName, email);
        }
        catch (Exception e) {
            log.error((Object)("Update user's subscription for user " + email + " failed because of " + e.getMessage()));
        }
    }

    public void updateSubscriptions(String portalName, String email, List<String> categoryAndSubscriptions) {
        log.info((Object)("Trying to update user's subscriptions for user " + email));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
            this.clearEmailInSubscription(email);
            this.updateSubscriptions(session, categoryAndSubscriptions, portalName, email);
        }
        catch (Exception e) {
            log.error((Object)("Update user's subscription for user " + email + " failed because of " + e.getMessage()));
        }
    }
}

