/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterSubscriptionHandler {
    private static Log log = ExoLogger.getLogger(NewsletterSubscriptionHandler.class);
    private RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
    private ThreadLocalSessionProviderService threadLocalSessionProviderService = (ThreadLocalSessionProviderService)ThreadLocalSessionProviderService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThreadLocalSessionProviderService.class));
    private String repository;
    private String workspace;

    public NewsletterSubscriptionHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    private NewsletterSubscriptionConfig getSubscriptionFormNode(Node subscriptionNode) throws Exception {
        NewsletterSubscriptionConfig subscriptionConfig = new NewsletterSubscriptionConfig();
        subscriptionConfig.setName(subscriptionNode.getName());
        subscriptionConfig.setTitle(subscriptionNode.getProperty("exo:newsletterSubscriptionTitle").getString());
        if (subscriptionNode.hasProperty("exo:newsletterSubscriptionDecription")) {
            subscriptionConfig.setDescription(subscriptionNode.getProperty("exo:newsletterSubscriptionDecription").getString());
        }
        subscriptionConfig.setCategoryName(subscriptionNode.getProperty("exo:newsletterSubscriptionCategoryName").getString());
        return subscriptionConfig;
    }

    public void add(SessionProvider sessionProvider, String portalName, NewsletterSubscriptionConfig subscription) throws Exception {
        log.info((Object)("Trying to add subcription " + subscription.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(path)).getNode(subscription.getCategoryName());
            Node subscriptionNode = categoryNode.addNode(subscription.getName(), "exo:newsletterSubscription");
            subscriptionNode.setProperty("exo:newsletterSubscriptionTitle", subscription.getTitle());
            subscriptionNode.setProperty("exo:newsletterSubscriptionDecription", subscription.getDescription());
            subscriptionNode.setProperty("exo:newsletterSubscriptionCategoryName", subscription.getCategoryName());
            ExtendedNode extSubscriptionNode = (ExtendedNode)subscriptionNode;
            if (extSubscriptionNode.canAddMixin("exo:privilegeable")) {
                extSubscriptionNode.addMixin("exo:privilegeable");
            }
            String[] arrayPers = new String[]{"read", "set_property"};
            extSubscriptionNode.setPermission("any", arrayPers);
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Add subcription " + subscription.getName() + " failed because of " + e.getMessage()));
            throw e;
        }
    }

    public void edit(String portalName, NewsletterSubscriptionConfig subscription, SessionProvider sessionProvider) {
        log.info((Object)("Trying to edit subcription " + subscription.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(path)).getNode(subscription.getCategoryName());
            Node subscriptionNode = categoryNode.getNode(subscription.getName());
            subscriptionNode.setProperty("exo:newsletterSubscriptionTitle", subscription.getTitle());
            subscriptionNode.setProperty("exo:newsletterSubscriptionDecription", subscription.getDescription());
            subscriptionNode.setProperty("exo:newsletterSubscriptionCategoryName", subscription.getCategoryName());
            categoryNode.save();
        }
        catch (Exception e) {
            log.error((Object)("Edit subcription " + subscription.getName() + " failed because of " + e.getMessage()));
        }
    }

    public void delete(String portalName, String categoryName, NewsletterSubscriptionConfig subscription, SessionProvider sessionProvider) {
        log.info((Object)("Trying to delete subcription " + subscription.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(path)).getNode(categoryName);
            Node subscriptionNode = categoryNode.getNode(subscription.getName());
            subscriptionNode.remove();
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Delete subcription " + subscription.getName() + " failed because of " + e.getMessage()));
        }
    }

    public List<NewsletterSubscriptionConfig> getSubscriptionsByCategory(String portalName, String categoryName, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterSubscriptionConfig> listSubscriptions = new ArrayList<NewsletterSubscriptionConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName);
        Node categoryNode = ((Node)session.getItem(path)).getNode(categoryName);
        NodeIterator nodeIterator = categoryNode.getNodes();
        while (nodeIterator.hasNext()) {
            try {
                Node childNode = nodeIterator.nextNode();
                if (!childNode.isNodeType("exo:newsletterSubscription")) continue;
                listSubscriptions.add(this.getSubscriptionFormNode(childNode));
            }
            catch (Exception ex) {
                log.error((Object)("Error when get subcriptions by category " + categoryName + " failed because of " + ex.getMessage()));
            }
        }
        return listSubscriptions;
    }

    public List<NewsletterSubscriptionConfig> getSubscriptionIdsByPublicUser(String portalName, String userEmail, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterSubscriptionConfig> listSubscriptions = new ArrayList<NewsletterSubscriptionConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterSubscription where exo:newsletterSubscribedUser = '" + userEmail + "'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            try {
                listSubscriptions.add(this.getSubscriptionFormNode(nodeIterator.nextNode()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return listSubscriptions;
    }

    public NewsletterSubscriptionConfig getSubscriptionsByName(String portalName, String categoryName, String subCriptionName, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName);
        Node categoryNode = ((Node)session.getItem(path)).getNode(categoryName);
        try {
            Node subNode = categoryNode.getNode(subCriptionName);
            return this.getSubscriptionFormNode(subNode);
        }
        catch (Exception e) {
            log.info((Object)("Node name is not found: " + subCriptionName));
            return null;
        }
    }

    public long getNumberOfNewslettersWaiting(String portalName, String categoryName, String subScriptionName, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subScriptionName;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterEntry where jcr:path LIKE '" + path + "[%]/%' and " + "exo:newsletterEntryStatus" + " = '" + "awaiting" + "'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        return nodeIterator.getSize();
    }
}

