/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.defaultlifecycle;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.services.ecm.publication.plugins.webui.UIPublicationLogList;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.defaultlifecycle.UIPortalNavigationExplorer;
import org.exoplatform.services.wcm.publication.defaultlifecycle.UIPublicationTree;
import org.exoplatform.services.wcm.publication.defaultlifecycle.UIPublishedPages;
import org.exoplatform.services.wcm.publication.defaultlifecycle.UIPublishingPanel;
import org.exoplatform.services.wcm.publication.defaultlifecycle.WCMPublicationPlugin;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/UIPublicationAction.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class})})
public class UIPublicationAction
extends UIForm {
    private void updateUI() throws Exception {
        UIPublishingPanel publishingPanel = (UIPublishingPanel)this.getAncestorOfType(UIPublishingPanel.class);
        UIPublishedPages publishedPages = (UIPublishedPages)publishingPanel.getChild(UIPublishedPages.class);
        Node node = publishingPanel.getNode();
        ArrayList<String> listPublishedPage = new ArrayList<String>();
        if (node.hasProperty("publication:navigationNodeURIs")) {
            Value[] navigationNodeURIs;
            for (Value navigationNodeURI : navigationNodeURIs = node.getProperty("publication:navigationNodeURIs").getValues()) {
                listPublishedPage.add(navigationNodeURI.getString());
            }
            publishedPages.setListNavigationNodeURI(listPublishedPage);
            UIComponent parent = publishingPanel.getParent();
            UIPublicationLogList publicationLogList = (UIPublicationLogList)parent.findFirstComponentOfType(UIPublicationLogList.class);
            publicationLogList.updateGrid();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIPublicationAction> {
        public void execute(Event<UIPublicationAction> event) throws Exception {
            Node contentNode;
            UIPublicationAction publicationAction = (UIPublicationAction)((Object)event.getSource());
            UIPublishingPanel publishingPanel = (UIPublishingPanel)publicationAction.getAncestorOfType(UIPublishingPanel.class);
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)publicationAction.getApplicationComponent(UserPortalConfigService.class);
            UIPublishedPages publishedPages = (UIPublishedPages)publishingPanel.getChild(UIPublishedPages.class);
            DataStorage dataStorage = (DataStorage)publicationAction.getApplicationComponent(DataStorage.class);
            String selectedNavigationNodeURI = publishedPages.getSelectedNavigationNodeURI();
            if (selectedNavigationNodeURI == null) {
                UIApplication application = (UIApplication)publicationAction.getAncestorOfType(UIApplication.class);
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.none", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            String portalName = selectedNavigationNodeURI.substring(1, selectedNavigationNodeURI.indexOf("/", 1));
            String pageNodeUri = selectedNavigationNodeURI.replaceFirst("/\\w+/", "");
            PageNavigation pageNavigation = null;
            Page page = null;
            Query query = new Query("portal", portalName, PageNavigation.class);
            PageList list = dataStorage.find(query);
            for (Object object : list.getAll()) {
                pageNavigation = (PageNavigation)PageNavigation.class.cast(object);
            }
            if (pageNavigation != null && (contentNode = publishingPanel.getNode()).hasProperty("publication:applicationIDs")) {
                PageNode pageNode = pageNavigation.getNode(pageNodeUri);
                page = userPortalConfigService.getPage(pageNode.getPageReference(), event.getRequestContext().getRemoteUser());
            }
            WCMPublicationService presentationService = (WCMPublicationService)publicationAction.getApplicationComponent(WCMPublicationService.class);
            WCMPublicationPlugin publicationPlugin = (WCMPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(WCMPublicationPlugin.LIFECYCLE_NAME);
            publicationPlugin.suspendPublishedContentFromPage(publishingPanel.getNode(), page);
            publicationAction.updateUI();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIPublicationAction> {
        public void execute(Event<UIPublicationAction> event) throws Exception {
            PageNode pageNode;
            UIPublicationAction publicationAction = (UIPublicationAction)((Object)event.getSource());
            UIPublishingPanel publishingPanel = (UIPublishingPanel)publicationAction.getAncestorOfType(UIPublishingPanel.class);
            UIApplication application = (UIApplication)publicationAction.getAncestorOfType(UIApplication.class);
            UIPortalNavigationExplorer portalNavigationExplorer = (UIPortalNavigationExplorer)publishingPanel.getChild(UIPortalNavigationExplorer.class);
            UIPublicationTree.TreeNode selectedNode = portalNavigationExplorer.getSelectedNode();
            if (selectedNode == null) {
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.none", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            String selectedNavigationNodeURI = selectedNode.getUri();
            Node node = publishingPanel.getNode();
            if (node.hasProperty("publication:navigationNodeURIs")) {
                Value[] navigationNodeURIs;
                for (Value navigationNodeURI : navigationNodeURIs = node.getProperty("publication:navigationNodeURIs").getValues()) {
                    if (!navigationNodeURI.getString().equals(selectedNavigationNodeURI)) continue;
                    application.addMessage(new ApplicationMessage("UIPublicationAction.msg.duplicate", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                    return;
                }
            }
            if ((pageNode = selectedNode.getPageNode()) == null) {
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.wrongNode", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)publicationAction.getApplicationComponent(UserPortalConfigService.class);
            Page page = userPortalConfigService.getPage(pageNode.getPageReference(), event.getRequestContext().getRemoteUser());
            WCMPublicationService presentationService = (WCMPublicationService)publicationAction.getApplicationComponent(WCMPublicationService.class);
            WCMPublicationPlugin publicationPlugin = (WCMPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(WCMPublicationPlugin.LIFECYCLE_NAME);
            publicationPlugin.publishContentToPage(node, page);
            publicationAction.updateUI();
        }
    }
}

