/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;

public class PaginatedNodeIterator
extends PageList {
    protected NodeIterator nodeIterator;

    public PaginatedNodeIterator(int pageSize) {
        super(pageSize);
    }

    public PaginatedNodeIterator(NodeIterator nodeIterator, int pageSize) {
        super(pageSize);
        this.nodeIterator = nodeIterator;
        this.setAvailablePage((int)nodeIterator.getSize());
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null) {
            return;
        }
        this.checkAndSetPosition(page);
        this.currentListPage_ = new ArrayList();
        int count = 0;
        while (this.nodeIterator.hasNext()) {
            this.currentListPage_.add(this.nodeIterator.next());
            if (++count != this.getPageSize()) continue;
        }
        this.currentPage_ = page;
    }

    public NodeIterator getNodeIterator() {
        return this.nodeIterator;
    }

    public void setNodeIterator(NodeIterator iterator) {
        this.nodeIterator = iterator;
    }

    public int getTotalPages() {
        return this.getAvailablePage();
    }

    public int getNodesPerPage() {
        return this.getPageSize();
    }

    public long getTotalNodes() {
        return this.nodeIterator.getSize();
    }

    public List getCurrentPageData() throws Exception {
        return this.currentPage();
    }

    public List getPage(int page) throws Exception {
        if (page < 1 || page > this.availablePage_) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.populateCurrentPage(page);
        return this.currentListPage_;
    }

    public void changePage(int page) throws Exception {
        this.populateCurrentPage(page);
    }

    protected void checkAndSetPosition(int page) {
        if (page > this.currentPage_) {
            long skipNextNum = (page - (this.currentPage_ + 1)) * this.getPageSize();
            this.nodeIterator.skip(skipNextNum);
        } else if (page < this.currentPage_) {
            int currentPageSize = this.currentListPage_.size();
            long skipBackNum = (this.currentPage_ - page) * this.getPageSize() + currentPageSize;
            ((TwoWayRangeIterator)this.nodeIterator).skipBack(skipBackNum);
        }
    }

    public List getAll() throws Exception {
        throw new UnsupportedOperationException();
    }
}

