/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterUserInfor;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UIManagerUsers;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UITabPane;

@ComponentConfig(template="app:/groovy/webui/newsletter/NewsletterManager/UIManagerUsers.gtmpl", events={@EventConfig(listeners={UnBanUserActionListener.class}), @EventConfig(listeners={BanUserActionListener.class}), @EventConfig(listeners={DeleteUserActionListener.class}), @EventConfig(listeners={AddAdministratorActionListener.class}), @EventConfig(listeners={DeleteAdministratorActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIManagerUsers
extends UITabPane {
    private String[] TITLE_ = new String[]{"Mail", "isBanned"};
    private String[] ACTIONS_ = new String[]{"Edit", "BanUser", "UnBanUser", "DeleteUser"};
    private String[] MEMBER_TITLE_ = new String[]{"UserName", "FirstName", "LastName", "Email", "Role"};
    private String[] MEMBER_ACTIONS_ = new String[]{"Edit", "AddAdministrator", "DeleteAdministrator"};
    private NewsletterManageUserHandler managerUserHandler = null;
    private String categoryName;
    private String subscriptionName;
    private String UIGRID_MANAGER_USERS = "UIManagerUsers";
    private String UIGRID_MANAGER_MODERATOR = "UIManagerModerator";
    private boolean isViewTab = false;
    private List<String> listModerator = new ArrayList();
    private String[] permissions;

    private void getListPublicUser() {
        try {
            UIGrid uiGrid = (UIGrid)this.getChildById(this.UIGRID_MANAGER_USERS);
            ObjectPageList objPageList = new ObjectPageList(this.managerUserHandler.getUsers(NewsLetterUtil.getPortalName(), this.categoryName, this.subscriptionName), 5);
            uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateListUser() throws Exception {
        List listAdministrator = this.managerUserHandler.getAllAdministrator(NewsLetterUtil.getPortalName());
        UIGrid uiGrid = (UIGrid)this.getChildById(this.UIGRID_MANAGER_MODERATOR);
        UIPageIterator uiIterator_ = uiGrid.getUIPageIterator();
        uiIterator_.setPageList(null);
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        service.getUserHandler().findUsers(new Query()).getAll();
        ArrayList<NewsletterUserInfor> userInfors = new ArrayList<NewsletterUserInfor>();
        for (Object obj : service.getUserHandler().findUsers(new Query()).getAll()) {
            User user = (User)obj;
            NewsletterUserInfor userInfor = new NewsletterUserInfor();
            userInfor.setEmail(user.getEmail());
            userInfor.setFirstName(user.getFirstName());
            userInfor.setLastName(user.getLastName());
            userInfor.setUserName(user.getUserName());
            if (listAdministrator.contains(user.getUserName())) {
                userInfor.setRole(this.permissions[0]);
            } else if (this.listModerator.contains(userInfor.getUserName())) {
                userInfor.setRole(this.permissions[1]);
            } else {
                userInfor.setRole(this.permissions[2]);
            }
            userInfors.add(userInfor);
        }
        ObjectPageList objPageList = new ObjectPageList(userInfors, 5);
        uiIterator_.setPageList((PageList)objPageList);
        this.setSelectedTab(this.UIGRID_MANAGER_USERS);
    }

    public UIManagerUsers() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.managerUserHandler = newsletterManagerService.getManageUserHandler();
        NewsletterCategoryHandler categoryHandler = newsletterManagerService.getCategoryHandler();
        for (NewsletterCategoryConfig categoryConfig : categoryHandler.getListCategories(NewsLetterUtil.getPortalName())) {
            for (String str : categoryConfig.getModerator().split(",")) {
                if (this.listModerator.contains(str)) continue;
                this.listModerator.add(str);
            }
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.permissions = new String[]{res.getString("UIManagerUsers.role.Administrator"), res.getString("UIManagerUsers.role.Moderator"), res.getString("UIManagerUsers.role.Redactor")};
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, this.UIGRID_MANAGER_USERS);
        uiGrid.getUIPageIterator().setId("UsersIterator");
        uiGrid.configure("Mail", this.TITLE_, this.ACTIONS_);
        this.addChild((UIComponent)uiGrid);
    }

    public void setInfor(String categoryName, String subscriptionName) {
        this.categoryName = categoryName;
        this.subscriptionName = subscriptionName;
        if (categoryName == null) {
            try {
                UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, this.UIGRID_MANAGER_MODERATOR);
                UIPageIterator uiIterator_ = uiGrid.getUIPageIterator();
                uiIterator_.setId("ModeratorsIterator");
                uiGrid.configure("UserName", this.MEMBER_TITLE_, this.MEMBER_ACTIONS_);
                this.addChild((UIComponent)uiGrid);
                this.isViewTab = true;
                this.setSelectedTab(this.UIGRID_MANAGER_USERS);
                this.updateListUser();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static /* synthetic */ NewsletterManageUserHandler access$000(UIManagerUsers x0) {
        return x0.managerUserHandler;
    }

    static /* synthetic */ void access$100(UIManagerUsers x0) throws Exception {
        x0.updateListUser();
    }

    static /* synthetic */ String access$200(UIManagerUsers x0) {
        return x0.UIGRID_MANAGER_MODERATOR;
    }
}

