/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryContainer;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryDialogSelector;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryForm;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryManager;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterManagerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={PreviewActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UINewsletterEntryForm
extends UIDialogForm {
    private static final Log log = ExoLogger.getLogger((String)"wcm:UINewsletterEntryForm");

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
            String repositoryName = newsletterManagerService.getRepositoryName();
            return templateService.getTemplatePathByUser(true, "exo:webContent", userName, repositoryName);
        }
        catch (Exception e) {
            log.error((Object)("Get template failed because of " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            if (this.resourceResolver == null) {
                NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
                String repositoryName = newsletterManagerService.getRepositoryName();
                DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
                String workspace = dmsConfiguration.getConfig(repositoryName).getSystemWorkspace();
                this.resourceResolver = new JCRResourceResolver(repositoryName, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Get template resource resolver failed because of " + e.getMessage()), (Throwable)e);
        }
        return this.resourceResolver;
    }

    private Node saveContent() throws Exception {
        UINewsletterEntryContainer newsletterEntryContainer = (UINewsletterEntryContainer)this.getAncestorOfType(UINewsletterEntryContainer.class);
        UINewsletterEntryDialogSelector newsletterEntryDialogSelector = (UINewsletterEntryDialogSelector)newsletterEntryContainer.getChild(UINewsletterEntryDialogSelector.class);
        String selectedCategory = (String)((UIFormSelectBox)newsletterEntryDialogSelector.getChildById("UINewsletterEntryCategorySelectBox")).getValue();
        String selectedSubsctiption = (String)((UIFormSelectBox)newsletterEntryDialogSelector.getChildById("UINewsletterEntrySubscriptionSelectBox")).getValue();
        this.setStoredPath(NewsletterConstant.generateSubscriptionPath((String)Util.getUIPortal().getName(), (String)selectedCategory, (String)selectedSubsctiption));
        Map inputProperties = DialogFormUtil.prepareMap((List)this.getChildren(), (Map)this.getInputProperties());
        if (this.isAddNew()) {
            String nodeName = Utils.cleanString((String)((String)this.getUIStringInput("title").getValue()));
            ((JcrInputProperty)inputProperties.get("/node")).setValue((Object)nodeName);
        }
        String storedPath = this.getStoredPath().replace("portalName", NewsLetterUtil.getPortalName());
        ThreadLocalSessionProviderService threadLocalSessionProviderService = (ThreadLocalSessionProviderService)this.getApplicationComponent(ThreadLocalSessionProviderService.class);
        SessionProvider sessionProvider = threadLocalSessionProviderService.getSessionProvider(null);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(this.repositoryName);
        Session session = sessionProvider.getSession(this.workspaceName, manageableRepository);
        Node storedNode = (Node)session.getItem(storedPath);
        CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
        String newsletterNodePath = cmsService.storeNode("exo:webContent", storedNode, inputProperties, this.isAddNew(), this.repositoryName);
        Node newsletterNode = (Node)session.getItem(newsletterNodePath);
        if (newsletterNode.canAddMixin("exo:newsletterEntry")) {
            newsletterNode.addMixin("exo:newsletterEntry");
        }
        newsletterNode.setProperty("exo:newsletterEntryCategoryName", selectedCategory);
        newsletterNode.setProperty("exo:newsletterEntrySubscriptionName", selectedSubsctiption);
        newsletterNode.setProperty("exo:newsletterEntryStatus", "draft");
        newsletterNode.setProperty("exo:newsletterEntryType", newsletterEntryDialogSelector.getDialog());
        ((UIFormDateTimeInput)newsletterEntryDialogSelector.getChildById("UINewsletterEntrySendDate")).getCalendar();
        newsletterNode.setProperty("exo:newsletterEntryDate", Calendar.getInstance());
        session.save();
        UIPopupContainer popupContainer = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
        UINewsletterManagerPortlet managerPortlet = (UINewsletterManagerPortlet)popupContainer.getAncestorOfType(UINewsletterManagerPortlet.class);
        UINewsletterEntryManager entryManager = (UINewsletterEntryManager)managerPortlet.getChild(UINewsletterEntryManager.class);
        if (entryManager.isRendered()) {
            entryManager.init();
        }
        Utils.closePopupWindow((UIContainer)popupContainer, (String)"UINewsletterEntryFormPopupWindow");
        return newsletterNode;
    }

    static /* synthetic */ Node access$000(UINewsletterEntryForm x0) throws Exception {
        return x0.saveContent();
    }
}

