/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config.social;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectmany.UICategoriesSelector;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UICategorizing
extends UIContainer
implements UISelectable {
    static final String PATH_CATEGORY = "path".intern();
    private Node webContentNode = null;
    private List<String> existedCategories = new ArrayList();

    public UICategorizing() throws Exception {
        this.addChild(UICategoriesSelector.class, null, null);
    }

    public void initUICategoriesSelector() throws Exception {
        UICategoriesSelector uiCateSelector = (UICategoriesSelector)this.getChild(UICategoriesSelector.class);
        uiCateSelector.setExistedCategoryList(this.getExistedCategories());
        uiCateSelector.setSourceComponent((UIComponent)this, null);
        uiCateSelector.init();
    }

    public void doSelect(String name, Object value) throws Exception {
        CategoriesService categoriesService = (CategoriesService)this.getApplicationComponent(CategoriesService.class);
        Node webContentNode = this.getWebContentNode();
        Session session = webContentNode.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        List newCategoryPaths = (List)value;
        List oldCategoryPaths = this.getExistedCategories();
        for (String oldCategory : oldCategoryPaths) {
            categoriesService.removeCategory(webContentNode, oldCategory, repositoryName);
        }
        for (String newCategory : newCategoryPaths) {
            newCategory = "/jcr:system/exo:ecm/exo:taxonomies/" + newCategory;
            categoriesService.addCategory(webContentNode, newCategory, repositoryName);
        }
    }

    public List<String> getExistedCategories() {
        return this.existedCategories;
    }

    public void setExistedCategories(List<String> existedCategories) {
        this.existedCategories = existedCategories;
    }

    public Node getWebContentNode() {
        return this.webContentNode;
    }

    public void setWebContentNode(Node webContentNode) {
        this.webContentNode = webContentNode;
    }
}

