/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.wiki;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.wcm.webui.wiki.UIWikiContentForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiContentForm
extends UIForm {
    public static final String NAME_CONTENT = "Name";
    public static final String CONTENT = "Content";
    public static final String TITLE = "Title";
    private String parentUri;
    private String pageUri;
    private PageNavigation pageNavigation;

    public UIWikiContentForm() throws Exception {
        UIFormStringInput nameInput = new UIFormStringInput(NAME_CONTENT, "");
        this.addChild((UIComponent)nameInput);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(TITLE, TITLE, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        UIFormWYSIWYGInput uiWYSWYGInput = new UIFormWYSIWYGInput(CONTENT, CONTENT, "");
        uiWYSWYGInput.setWidth(String.valueOf(750));
        this.addChild((UIComponent)uiWYSWYGInput);
    }

    public String createNewPage(String pageName, String newNodeUUID) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserPortalConfigService portalCfgService = (UserPortalConfigService)uiPortal.getApplicationComponent(UserPortalConfigService.class);
        UIPortlet scvPortlet = this.createSCVPortlet(uiPortal, newNodeUUID);
        PortalRequestContext webuiReqContext = Util.getPortalRequestContext();
        UIPage uiPage = (UIPage)uiPortal.createUIComponent((WebuiRequestContext)webuiReqContext, UIPage.class, null, null);
        uiPage.setEditPermission(uiPortal.getEditPermission());
        uiPage.setAccessPermissions(new String[]{"Everyone"});
        uiPage.setOwnerId(uiPortal.getName());
        uiPage.setOwnerType("portal");
        uiPage.setName(pageName);
        Page page = PortalDataMapper.toPageModel((UIPage)uiPage);
        portalCfgService.create(page);
        this.addSCVPortletIntoPage(scvPortlet, uiPage, page, portalCfgService);
        PageNavigation pageNavigation = this.getPageNavigation();
        PageNode parentPageNode = null;
        for (PageNode pageNode : pageNavigation.getNodes()) {
            if (!pageNode.getUri().equals(this.getParentUri())) continue;
            parentPageNode = pageNode;
            break;
        }
        PageNode newPageNode = this.createNewPageNode(parentPageNode, page.getPageId());
        portalCfgService.update(pageNavigation);
        return newPageNode.getUri();
    }

    private PageNode createNewPageNode(PageNode parentPageNode, String pageId) throws Exception {
        PageNode newPageNode = null;
        if (this.getPageUri().indexOf("/") > 0) {
            String[] pageNodeNames;
            for (String newPageNodeName : pageNodeNames = this.getPageUri().split("/")) {
                parentPageNode = newPageNode = this.createNewPageNode(parentPageNode, newPageNodeName, pageId);
            }
        } else {
            newPageNode = this.createNewPageNode(parentPageNode, this.getPageUri(), pageId);
        }
        return newPageNode;
    }

    private UIPortlet createSCVPortlet(UIPortal uiPortal, String newNodeUUID) throws Exception {
        UIPortlet scvPortlet = new UIPortlet();
        scvPortlet.setShowInfoBar(Boolean.valueOf(false));
        WCMConfigurationService wcmCfgService = (WCMConfigurationService)uiPortal.getApplicationComponent(WCMConfigurationService.class);
        StringBuilder windowId = new StringBuilder();
        String random = IdGenerator.generate();
        windowId.append("portal").append("#").append(uiPortal.getOwner()).append(":").append(wcmCfgService.getRuntimeContextParam("SCVPortlet")).append("/").append(random);
        scvPortlet.setWindowId(windowId.toString());
        PortletPreferences prefs = new PortletPreferences();
        prefs.setWindowId(windowId.toString());
        prefs.setOwnerType("portal");
        prefs.setOwnerId(uiPortal.getOwner());
        ArrayList<Preference> preferenceList = new ArrayList<Preference>();
        Preference prefR = new Preference();
        RepositoryService repoService = (RepositoryService)uiPortal.getApplicationComponent(RepositoryService.class);
        String repositoryName = repoService.getCurrentRepository().getConfiguration().getName();
        ArrayList<String> listValue = new ArrayList<String>();
        listValue.add(repositoryName);
        prefR.setName(UISingleContentViewerPortlet.REPOSITORY);
        prefR.setValues(listValue);
        preferenceList.add(prefR);
        Preference prefW = new Preference();
        NodeLocation nodeLocation = wcmCfgService.getLivePortalsLocation(repositoryName);
        String workspaceName = nodeLocation.getWorkspace();
        listValue = new ArrayList();
        listValue.add(workspaceName);
        prefW.setName(UISingleContentViewerPortlet.WORKSPACE);
        prefW.setValues(listValue);
        preferenceList.add(prefW);
        Preference prefI = new Preference();
        listValue = new ArrayList();
        listValue.add(newNodeUUID);
        prefI.setName(UISingleContentViewerPortlet.IDENTIFIER);
        prefI.setValues(listValue);
        preferenceList.add(prefI);
        prefs.setPreferences(preferenceList);
        DataStorage ds = (DataStorage)this.getApplicationComponent(DataStorage.class);
        ds.save(prefs);
        return scvPortlet;
    }

    private void addSCVPortletIntoPage(UIPortlet scvPortlet, UIPage uiPage, Page page, UserPortalConfigService userPortalCfgService) throws Exception {
        ArrayList listPortlet = page.getChildren();
        listPortlet.add(PortalDataMapper.toPortletModel((UIPortlet)scvPortlet));
        page.setChildren(listPortlet);
        userPortalCfgService.update(page);
        uiPage.setChildren(null);
        PortalDataMapper.toUIPage((UIPage)uiPage, (Page)page);
    }

    private Node createNewWebContentNode(String webContentName, String title, String content) throws Exception {
        String portalName = Util.getUIPortal().getName();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        Node portalNode = livePortalManagerService.getLivePortal(portalName, Utils.getSessionProvider((UIComponent)this));
        WebSchemaConfigService webSchemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        PortalFolderSchemaHandler handler = (PortalFolderSchemaHandler)webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        Node webContentStorage = handler.getWebContentStorage(portalNode);
        Node webContentNode = webContentStorage.addNode(webContentName, "exo:webContent");
        WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        webContentSchemaHandler.createDefaultSchema(webContentNode);
        webContentNode.getNode("default.html/jcr:content").setProperty("jcr:data", content);
        webContentNode.setProperty("exo:title", title);
        Session session = webContentStorage.getSession();
        session.save();
        return webContentNode;
    }

    private PageNode createNewPageNode(PageNode parentPageNode, String newPageNodeName, String pageID) throws Exception {
        PageNode newPageNode = new PageNode();
        newPageNode.setName(newPageNodeName);
        newPageNode.setLabel(newPageNodeName);
        newPageNode.setUri(parentPageNode.getUri() + "/" + newPageNodeName);
        newPageNode.setPageReference(pageID);
        ArrayList<PageNode> children = parentPageNode.getChildren();
        if (children != null) {
            for (PageNode child : children) {
                if (!child.getName().equals(newPageNodeName)) continue;
                return child;
            }
        } else {
            children = new ArrayList<PageNode>();
        }
        children.add(newPageNode);
        parentPageNode.setChildren(children);
        return newPageNode;
    }

    private String getNewNodeURL(HttpServletRequestWrapper reqWrapper, String newNodeUri) {
        String scheme = reqWrapper.getScheme();
        PortalRequestContext portalReqContext = Util.getPortalRequestContext();
        String portalUri = portalReqContext.getPortalURI();
        String serverName = reqWrapper.getServerName();
        String serverPort = String.valueOf(reqWrapper.getServerPort());
        String link = scheme + "://" + serverName + ":" + serverPort + portalUri + newNodeUri;
        return link;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        String queryString = requestWrapper.getQueryString();
        String[] parameterArr = queryString.split("&");
        String parentUri = parameterArr[0].split("=")[1];
        String pageUri = parameterArr[1].split("=")[1];
        UIPortal uiPortal = Util.getUIPortal();
        List navigations = uiPortal.getNavigations();
        PageNavigation pageNavigation = null;
        for (PageNavigation paNavigation : navigations) {
            if (!"portal".equals(paNavigation.getOwnerType())) continue;
            pageNavigation = paNavigation;
            break;
        }
        this.setPageNavigation(pageNavigation);
        this.setParentUri(parentUri);
        this.setPageUri(pageUri);
        super.processRender(context);
    }

    public PageNavigation getPageNavigation() {
        return this.pageNavigation;
    }

    public void setPageNavigation(PageNavigation pageNavigation) {
        this.pageNavigation = pageNavigation;
    }

    public String getParentUri() {
        return this.parentUri;
    }

    public void setParentUri(String parentUri) {
        this.parentUri = parentUri;
    }

    public String getPageUri() {
        return this.pageUri;
    }

    public void setPageUri(String pageUri) {
        this.pageUri = pageUri;
    }

    static /* synthetic */ Node access$000(UIWikiContentForm x0, String x1, String x2, String x3) throws Exception {
        return x0.createNewWebContentNode(x1, x2, x3);
    }

    static /* synthetic */ String access$100(UIWikiContentForm x0, HttpServletRequestWrapper x1, String x2) {
        return x0.getNewNodeURL(x1, x2);
    }
}

