/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIPCVContainer;
import org.exoplatform.wcm.webui.pcv.UIPCVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ParameterizedContentViewer/UIPCVContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPCVContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isObsoletedContent = false;
    private UIPCVPresentation uiContentViewer;
    private String repository;
    private boolean isPrint;

    public UIPCVContainer() throws Exception {
        this.addChild(UIPCVPresentation.class, null, null);
        this.uiContentViewer = (UIPCVPresentation)this.getChild(UIPCVPresentation.class);
    }

    public String getRepository() throws RepositoryException {
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.repository = porletRequestContext.getRequest().getPreferences().getValue("repository", "");
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public Node getNode() throws Exception {
        String parameters = this.getRequestParameters();
        Node node = this.getNodebyPath(parameters);
        if (node == null) {
            node = this.getNodeByCategory(parameters);
        }
        if (node == null) {
            return null;
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentTypes = templateService.getDocumentTemplates(this.getRepository());
        boolean isDocumentType = false;
        for (String documentType : documentTypes) {
            if (!node.isNodeType(documentType)) continue;
            isDocumentType = true;
            break;
        }
        if (!isDocumentType) {
            return null;
        }
        if (this.hasChildren()) {
            this.removeChild(UIPCVContainer.class);
        }
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        String lifecycleName = null;
        try {
            lifecycleName = publicationService.getNodeLifecycleName(node);
        }
        catch (NotInPublicationLifecycleException e) {
            // empty catch block
        }
        Node nodeView = null;
        if (lifecycleName == null) {
            nodeView = node;
        } else {
            PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecycleName);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("filter-mode", Utils.getCurrentMode());
            nodeView = publicationPlugin.getNodeView(node, context);
        }
        if (nodeView != null && nodeView.isNodeType("nt:frozenNode")) {
            String nodeUUID = nodeView.getProperty("jcr:frozenUuid").getString();
            this.uiContentViewer.setOrginalNode(node.getSession().getNodeByUUID(nodeUUID));
            this.uiContentViewer.setNode(nodeView);
        } else {
            if (nodeView == null) {
                return null;
            }
            this.uiContentViewer.setOrginalNode(nodeView);
            this.uiContentViewer.setNode(nodeView);
        }
        this.uiContentViewer.setRepository(this.getRepository());
        this.uiContentViewer.setWorkspace(nodeView.getSession().getWorkspace().getName());
        WCMPublicationService wcmPublicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        String contentState = wcmPublicationService.getContentState(nodeView);
        this.isDraftRevision = "draft".equals(contentState);
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)porletRequestContext.getRequest();
        this.isPrint = "isPrint=true".equals(request.getQueryString());
        return nodeView;
    }

    private String getRequestParameters() {
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getUri();
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        if (!parameters.matches("(.*)/(.*)")) {
            return null;
        }
        return parameters;
    }

    private Node getNodebyPath(String parameters) throws Exception {
        if (parameters == null) {
            return null;
        }
        ManageableRepository manageableRepository = null;
        String[] params = parameters.split("/");
        String repository = params[0];
        String workspace = params[1];
        try {
            RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            manageableRepository = repositoryService.getRepository(repository);
        }
        catch (Exception e) {
            return null;
        }
        String nodeIdentifier = null;
        Node currentNode = null;
        Session session = Utils.getSessionProvider((org.exoplatform.webui.core.UIContainer)this).getSession(workspace, manageableRepository);
        if (params.length > 2) {
            StringBuffer identifier = new StringBuffer();
            for (int i = 2; i < params.length; ++i) {
                identifier.append("/").append(params[i]);
            }
            nodeIdentifier = identifier.toString();
            boolean isUUID = false;
            try {
                currentNode = (Node)session.getItem(nodeIdentifier);
            }
            catch (Exception e) {
                isUUID = true;
            }
            if (isUUID) {
                try {
                    String uuid = params[params.length - 1];
                    currentNode = session.getNodeByUUID(uuid);
                }
                catch (ItemNotFoundException exc) {
                    return null;
                }
            }
        } else if (params.length == 2) {
            currentNode = session.getRootNode();
        }
        return currentNode;
    }

    private Node getNodeByCategory(String parameters) throws Exception {
        if (parameters == null) {
            return null;
        }
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        String[] params = parameters.split("/");
        Node taxonomyTree = taxonomyService.getTaxonomyTree(this.getRepository(), params[0]);
        String symLinkPath = parameters.substring(parameters.indexOf("/") + 1);
        try {
            Node symLink = taxonomyTree.getNode(symLinkPath);
            return taxonomyTree.getSession().getNodeByUUID(symLink.getProperty("exo:uuid").getString());
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public boolean isQuickEditAble() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return Utils.turnOnQuickEditable((PortletRequestContext)context, (boolean)true);
    }

    public void renderErrorMessage(WebuiRequestContext context, String keyBundle) throws Exception {
        Writer writer = context.getWriter();
        String message = context.getApplicationResourceBundle().getString(keyBundle);
        writer.write("<div style=\"height: 55px; font-size: 13px; text-align: center; padding-top: 10px;\">");
        writer.write("<span>");
        writer.write(message);
        writer.write("</span>");
        writer.write("</div>");
        writer.close();
    }

    public boolean getIsPrint() {
        return this.isPrint;
    }

    public void setIsPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    public void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean isObsoletedContent() {
        return this.isObsoletedContent;
    }

    public void setObsoletedContent(boolean isObsoletedContent) {
        this.isObsoletedContent = isObsoletedContent;
    }
}

