/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.wcm.webui.clv.UIContentListViewerPortlet;
import org.exoplatform.wcm.webui.clv.UIListViewerBase;
import org.exoplatform.wcm.webui.clv.config.UIPortletConfig;
import org.exoplatform.wcm.webui.clv.config.UIViewerManagementForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/ContentListViewer/config/UIViewerManagementForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SelectFolderPathActionListener.class}), @EventConfig(listeners={IncreaseActionListener.class}), @EventConfig(listeners={DecreaseActionListener.class})})
public class UIViewerManagementForm
extends UIForm
implements UISelectable {
    private List<String> contentList = new ArrayList();
    public static final String HEADER = "Header";
    public static final String PORTLET_NAME = "Content List Viewer";
    public static final String FORM_VIEW_TEMPLATE_CATEGORY = "list-by-folder";
    public static final String PAGINATOR_TEMPLATE_CATEGORY = "paginators";
    public static final String FOLDER_PATH_INPUTSET = "FolderPathInputSet";
    public static final String FOLDER_PATH_INPUT = "FolderPathInput";
    public static final String FORM_VIEW_TEMPLATES_SELECTOR = "FormViewTemplate";
    public static final String PAGINATOR_TEMPLATES_SELECTOR = "PaginatorTemplate";
    public static final String ITEMS_PER_PAGE_INPUT = "ItemsPerPage";
    public static final String VIEWER_BUTTON_REFRESH = "ViewerButtonRefresh";
    public static final String VIEWER_THUMBNAILS_IMAGE = "ViewerThumbnailsView";
    public static final String VIEWER_TITLE = "ViewerTitle";
    public static final String VIEWER_DATE_CREATED = "ViewerDateCreated";
    public static final String VIEWER_SUMMARY = "ViewerSummary";
    public static final String VIEWER_HEADER = "ViewerHeader";
    public static final String VIEWER_MODES = "ViewerMode";
    public static final String VIEWER_MANUAL_MODE = "ManualViewerMode";
    public static final String VIEWER_AUTO_MODE = "AutoViewerMode";
    public static final String ORDER_BY = "OrderBy";
    public static final String ORDER_BY_TITLE = "OrderByTitle";
    public static final String ORDER_BY_DATE_CREATED = "OrderByDateCreated";
    public static final String ORDER_BY_DATE_MODIFIED = "OrderByDateModified";
    public static final String ORDER_BY_DATE_PUBLISHED = "OrderByDatePublished";
    public static final String ORDER_TYPES = "OrderTypes";
    public static final String ORDER_DESC = "OrderDesc";
    public static final String ORDER_ASC = "OrderAsc";
    public static final int popupWidth = 700;

    public UIViewerManagementForm() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        ResourceBundle bundle = context.getApplicationResourceBundle();
        String rootBundleKey = "UIViewerManagementForm.label.";
        String folderPath = portletPreferences.getValue("folderPath", "folderPath");
        UIFormStringInput headerInput = new UIFormStringInput(HEADER, HEADER, null);
        String headerValue = portletPreferences.getValue("header", null);
        headerInput.setValue((Object)headerValue);
        List formViewerTemplateList = this.getTemplateList(PORTLET_NAME, FORM_VIEW_TEMPLATE_CATEGORY);
        List paginatorTemplateList = this.getTemplateList(PORTLET_NAME, PAGINATOR_TEMPLATE_CATEGORY);
        ArrayList<SelectItemOption> viewerModeOptions = new ArrayList<SelectItemOption>();
        viewerModeOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + VIEWER_AUTO_MODE), (Object)VIEWER_AUTO_MODE));
        viewerModeOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + VIEWER_MANUAL_MODE), (Object)VIEWER_MANUAL_MODE));
        ArrayList<SelectItemOption> orderTypeOptions = new ArrayList<SelectItemOption>();
        orderTypeOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + ORDER_DESC), (Object)"DESC"));
        orderTypeOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + ORDER_ASC), (Object)"ASC"));
        UIFormRadioBoxInput orderTypeRadioBoxInput = new UIFormRadioBoxInput(ORDER_TYPES, ORDER_TYPES, orderTypeOptions);
        String orderTypePref = portletPreferences.getValue("orderType", null);
        if (orderTypePref == null) {
            orderTypeRadioBoxInput.setValue((Object)"DESC");
        } else {
            orderTypeRadioBoxInput.setValue((Object)orderTypePref);
        }
        ArrayList<SelectItemOption> orderByOptions = new ArrayList<SelectItemOption>();
        orderByOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + ORDER_BY_TITLE), (Object)"exo:title"));
        orderByOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + ORDER_BY_DATE_CREATED), (Object)"exo:dateCreated"));
        orderByOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + ORDER_BY_DATE_MODIFIED), (Object)"exo:dateModified"));
        orderByOptions.add(new SelectItemOption(bundle.getString(rootBundleKey + ORDER_BY_DATE_PUBLISHED), (Object)"publication:liveDate"));
        UIFormRadioBoxInput viewerModeRadioBoxInput = new UIFormRadioBoxInput(VIEWER_MODES, VIEWER_MODES, viewerModeOptions);
        UIFormSelectBox orderBySelectBox = new UIFormSelectBox(ORDER_BY, ORDER_BY, orderByOptions);
        String orderByPref = portletPreferences.getValue("orderBy", null);
        orderBySelectBox.setValue(orderByPref);
        UIFormInputSetWithAction folderPathInputSet = new UIFormInputSetWithAction(FOLDER_PATH_INPUTSET);
        UIFormStringInput folderPathInput = new UIFormStringInput(FOLDER_PATH_INPUT, FOLDER_PATH_INPUT, null);
        folderPathInput.setEditable(false);
        if (folderPath != null) {
            folderPathInput.setValue((Object)folderPath);
        }
        folderPathInputSet.addChild((UIComponent)folderPathInput);
        folderPathInputSet.setActionInfo(FOLDER_PATH_INPUT, new String[]{"SelectFolderPath"});
        UIFormStringInput itemsPerPageStringInput = new UIFormStringInput(ITEMS_PER_PAGE_INPUT, ITEMS_PER_PAGE_INPUT, null);
        UIFormSelectBox formViewTemplateSelector = new UIFormSelectBox(FORM_VIEW_TEMPLATES_SELECTOR, FORM_VIEW_TEMPLATES_SELECTOR, formViewerTemplateList);
        UIFormSelectBox paginatorTemplateSelector = new UIFormSelectBox(PAGINATOR_TEMPLATES_SELECTOR, PAGINATOR_TEMPLATES_SELECTOR, paginatorTemplateList);
        UIFormCheckBoxInput viewerButtonRefreshCheckbox = new UIFormCheckBoxInput(VIEWER_BUTTON_REFRESH, VIEWER_BUTTON_REFRESH, null);
        viewerButtonRefreshCheckbox.setChecked(true);
        UIFormCheckBoxInput thumbnailsViewCheckbox = new UIFormCheckBoxInput(VIEWER_THUMBNAILS_IMAGE, VIEWER_THUMBNAILS_IMAGE, null);
        thumbnailsViewCheckbox.setChecked(true);
        UIFormCheckBoxInput titleViewerCheckbox = new UIFormCheckBoxInput(VIEWER_TITLE, VIEWER_TITLE, null);
        titleViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput summaryViewerCheckbox = new UIFormCheckBoxInput(VIEWER_SUMMARY, VIEWER_SUMMARY, null);
        summaryViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput dateCreatedViewerCheckbox = new UIFormCheckBoxInput(VIEWER_DATE_CREATED, VIEWER_DATE_CREATED, null);
        dateCreatedViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput viewerHeader = new UIFormCheckBoxInput(VIEWER_HEADER, VIEWER_HEADER, null);
        viewerHeader.setChecked(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        String refreshAble = portletPreferences.getValue("showRefreshButton", null);
        viewerButtonRefreshCheckbox.setChecked(Boolean.parseBoolean(refreshAble));
        String imageShowAble = portletPreferences.getValue("showThumbnailsView", null);
        thumbnailsViewCheckbox.setChecked(Boolean.parseBoolean(imageShowAble));
        String titleShowAble = portletPreferences.getValue("showTitle", null);
        titleViewerCheckbox.setChecked(Boolean.parseBoolean(titleShowAble));
        String summaryShowAble = portletPreferences.getValue("showSummary", null);
        summaryViewerCheckbox.setChecked(Boolean.parseBoolean(summaryShowAble));
        String dateShowAble = portletPreferences.getValue("showDateCreated", null);
        dateCreatedViewerCheckbox.setChecked(Boolean.parseBoolean(dateShowAble));
        String formViewTemplate = portletPreferences.getValue("formViewTemplatePath", null);
        formViewTemplateSelector.setValue(formViewTemplate);
        String paginatorTemplate = portletPreferences.getValue("paginatorTemplatePath", null);
        paginatorTemplateSelector.setValue(paginatorTemplate);
        String itemsPerPageVal = portletPreferences.getValue("itemsPerPage", null);
        itemsPerPageStringInput.setValue((Object)itemsPerPageVal);
        itemsPerPageStringInput.setMaxLength(3);
        if (this.isManualMode()) {
            orderBySelectBox.setRendered(false);
            viewerModeRadioBoxInput.setValue((Object)VIEWER_MANUAL_MODE);
            String[] arr = portletPreferences.getValues("contents", null);
            if (arr != null && arr.length != 0) {
                this.contentList = Arrays.asList(arr);
            }
        } else {
            viewerModeRadioBoxInput.setValue((Object)VIEWER_AUTO_MODE);
            orderBySelectBox.setRendered(true);
        }
        this.addChild((UIComponent)viewerModeRadioBoxInput);
        this.addChild((UIComponent)folderPathInputSet);
        this.addChild((UIComponent)orderBySelectBox);
        this.addChild((UIComponent)orderTypeRadioBoxInput);
        this.addChild((UIComponent)headerInput);
        this.addChild((UIComponent)formViewTemplateSelector);
        this.addChild((UIComponent)paginatorTemplateSelector);
        this.addChild((UIComponent)itemsPerPageStringInput);
        this.addChild((UIComponent)viewerButtonRefreshCheckbox);
        this.addChild((UIComponent)thumbnailsViewCheckbox);
        this.addChild((UIComponent)titleViewerCheckbox);
        this.addChild((UIComponent)dateCreatedViewerCheckbox);
        this.addChild((UIComponent)summaryViewerCheckbox);
        this.addChild((UIComponent)viewerHeader);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setViewAbleContentList(List<String> list) {
        this.contentList = list;
    }

    public List<String> getViewAbleContentList() {
        return this.contentList;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)((String)value));
        this.showPopupComponent(null);
    }

    public void showPopupComponent(UIComponent uiComponent) throws Exception {
        UIPortletConfig uiPortletConfig = (UIPortletConfig)this.getAncestorOfType(UIPortletConfig.class);
        UIPopupContainer uiPopupContainer = (UIPopupContainer)uiPortletConfig.getChild(UIPopupContainer.class);
        if (uiComponent == null) {
            uiPopupContainer.deActivate();
            return;
        }
        uiComponent.setRendered(true);
        uiPopupContainer.activate(uiComponent, 700, -1);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        context.addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
    }

    public boolean isManualMode() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = context.getRequest().getPreferences();
        String viewerMode = preferences.getValue("mode", null);
        return viewerMode != null && !VIEWER_AUTO_MODE.equals(viewerMode.toString());
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateOptionList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodeList = templateManagerService.getTemplatesByCategory(repository, portletName, category, provider);
        for (Node templateNode : templateNodeList) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templateOptionList.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templateOptionList;
    }

    public void activeNewViewerMode(UIListViewerBase uiNewViewer) throws Exception {
        UIContentListViewerPortlet uiListViewerPortlet = (UIContentListViewerPortlet)this.getAncestorOfType(UIContentListViewerPortlet.class);
        uiListViewerPortlet.removeChild(UIListViewerBase.class);
        uiListViewerPortlet.addChild((UIComponent)uiNewViewer);
        uiNewViewer.init();
    }

    public void resetViewerMode(UIListViewerBase uiViewer) throws Exception {
        uiViewer.getChildren().clear();
        uiViewer.init();
    }
}

