/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.publication.PublicationState;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.Constant;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIContentViewer;
import org.exoplatform.wcm.webui.pcv.UIContentViewerContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ParameterizedContentViewer/UIContentViewerContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIContentViewerContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isObsoletedContent = false;
    private UIContentViewer uiContentViewer;
    private boolean isPrint;

    public UIContentViewerContainer() throws Exception {
        this.addChild(UIContentViewer.class, null, null);
        this.uiContentViewer = (UIContentViewer)this.getChild(UIContentViewer.class);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getName();
        String parameters = null;
        Object object = requestWrapper.getAttribute("ParameterizedContentViewerPortlet.data.object");
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (!parameters.matches("(.*)/(.*)")) {
            this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
            return;
        }
        String nodeIdentifier = null;
        String[] params = parameters.split("/");
        String repository = params[0];
        String workspace = params[1];
        Node currentNode = null;
        SessionProvider sessionProvider = null;
        Session session = null;
        String userId = Util.getPortalRequestContext().getRemoteUser();
        sessionProvider = userId == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        if (object instanceof ItemNotFoundException || object instanceof AccessControlException || object instanceof ItemNotFoundException || object == null) {
            try {
                RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                ManageableRepository manageableRepository = repositoryService.getRepository(repository);
                session = sessionProvider.getSession(workspace, manageableRepository);
            }
            catch (AccessControlException ace) {
                this.renderErrorMessage(context, "UIMessageBoard.msg.access-control-exc");
                return;
            }
            catch (Exception e) {
                this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
                return;
            }
            if (params.length > 2) {
                StringBuffer identifier = new StringBuffer();
                for (int i = 2; i < params.length; ++i) {
                    identifier.append("/").append(params[i]);
                }
                nodeIdentifier = identifier.toString();
                boolean isUUID = false;
                try {
                    currentNode = (Node)session.getItem(nodeIdentifier);
                }
                catch (Exception e) {
                    isUUID = true;
                }
                if (isUUID) {
                    try {
                        String uuid = params[params.length - 1];
                        currentNode = session.getNodeByUUID(uuid);
                    }
                    catch (ItemNotFoundException exc) {
                        this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-found");
                        return;
                    }
                }
            } else if (params.length == 2) {
                currentNode = session.getRootNode();
            }
        } else {
            currentNode = (Node)object;
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentTypes = templateService.getDocumentTemplates(repository);
        Boolean isDocumentType = false;
        for (String docType : documentTypes) {
            if (!currentNode.isNodeType(docType)) continue;
            isDocumentType = true;
            break;
        }
        if (currentNode.isNodeType("exo:hiddenable")) {
            this.renderErrorMessage(context, "UIMessageBoard.msg.access-control-exc");
            return;
        }
        if (isDocumentType.booleanValue()) {
            if (this.hasChildren()) {
                this.removeChild(UIContentViewerContainer.class);
            }
            PublicationService publicationService = (PublicationService)uiPortal.getApplicationComponent(PublicationService.class);
            HashMap<String, Constant.SITE_MODE> hmContext = new HashMap<String, Constant.SITE_MODE>();
            if (Utils.isLiveMode()) {
                hmContext.put(Constant.RUNTIME_MODE, Constant.SITE_MODE.LIVE);
            } else {
                hmContext.put(Constant.RUNTIME_MODE, Constant.SITE_MODE.EDITING);
            }
            String lifeCycleName = publicationService.getNodeLifecycleName(currentNode);
            PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifeCycleName);
            if (publicationPlugin == null) {
                this.renderErrorMessage(context, "UIMessageBoard.msg.content-not-printed");
                return;
            }
            Node nodeView = publicationPlugin.getNodeView(currentNode, hmContext);
            this.uiContentViewer.setRepository(repository);
            this.uiContentViewer.setWorkspace(workspace);
            this.uiContentViewer.setOrginalNode(currentNode);
            if (nodeView != null) {
                this.uiContentViewer.setNode(nodeView);
            } else {
                this.uiContentViewer.setNode(currentNode);
            }
            String state = PublicationState.getRevisionState((Node)this.uiContentViewer.getNode());
            if (Constant.OBSOLETE_STATE.equals(state)) {
                this.setObsoletedContent(true);
                this.renderErrorMessage(context, "UIMessageBoard.msg.content-obsolete");
                return;
            }
            this.setObsoletedContent(false);
            if (Constant.DRAFT_STATE.equals(state)) {
                this.setDraftRevision(true);
            } else {
                this.setDraftRevision(false);
            }
            HttpServletRequest request = (HttpServletRequest)context.getRequest();
            this.isPrint = "isPrint=true".equals(request.getQueryString());
            super.processRender(context);
        } else {
            this.renderErrorMessage(context, "UIMessageBoard.msg.content-unsupport-exc");
        }
    }

    public boolean isQuickEditAble() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return Utils.turnOnQuickEditable((PortletRequestContext)context, (boolean)true);
    }

    public void renderErrorMessage(WebuiRequestContext context, String keyBundle) throws Exception {
        Writer writer = context.getWriter();
        String message = context.getApplicationResourceBundle().getString(keyBundle);
        writer.write("<div style=\"height: 55px; font-size: 13px; text-align: center; padding-top: 10px;\">");
        writer.write("<span>");
        writer.write(message);
        writer.write("</span>");
        writer.write("</div>");
        writer.close();
    }

    public boolean getIsPrint() {
        return this.isPrint;
    }

    public void setIsPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    public void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean isObsoletedContent() {
        return this.isObsoletedContent;
    }

    public void setObsoletedContent(boolean isObsoletedContent) {
        this.isObsoletedContent = isObsoletedContent;
    }
}

