/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import javax.jcr.Node;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.pcv.UIDocumentDialogForm;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveDraftActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={FastPublishActionListener.class})})
public class UIDocumentDialogForm
extends UIDialogForm
implements UIPopupComponent {
    private Node documentNode;

    public void setDocumentNode(Node node) {
        this.documentNode = node;
    }

    public Node getDocumentNode() {
        return this.documentNode;
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName, this.repositoryName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            if (this.resourceResolver == null) {
                RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                ManageableRepository manageableRepository = repositoryService.getRepository(this.repositoryName);
                String workspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
                this.resourceResolver = new JCRResourceResolver(this.repositoryName, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.resourceResolver;
    }

    private void closePopupAndUpdateUI(WebuiRequestContext requestContext) throws Exception {
        UIPopupWindow uiPopupWindow = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
        uiPopupWindow.setShow(false);
        requestContext.addUIComponentToUpdateByAjax((UIComponent)uiPopupWindow);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ boolean access$000(UIDocumentDialogForm x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$100(UIDocumentDialogForm x0) {
        return x0.repositoryName;
    }

    static /* synthetic */ void access$200(UIDocumentDialogForm x0, WebuiRequestContext x1) throws Exception {
        x0.closePopupAndUpdateUI(x1);
    }

    static /* synthetic */ boolean access$300(UIDocumentDialogForm x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$400(UIDocumentDialogForm x0) {
        return x0.repositoryName;
    }
}

