/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.images.RESTImagesRendererService;
import org.exoplatform.services.wcm.publication.PublicationState;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.Constant;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UIContentListPresentation;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={EditContentActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UIContentListPresentation
extends UIContainer {
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String contentColumn;
    private boolean showLink;
    private boolean showHeader;
    private String header;
    private DateFormat dateFormatter = null;

    public void init(String templatePath, ResourceResolver resourceResolver, PageList dataPageList) throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String paginatorTemplatePath = portletPreferences.getValue("paginatorTemplatePath", null);
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageList(dataPageList);
        Locale locale = Util.getPortalRequestContext().getLocale();
        this.dateFormatter = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        return portletPreferences;
    }

    public boolean showRefreshButton() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String isShow = portletPreferences.getValue("showRefreshButton", null);
        return isShow != null ? Boolean.parseBoolean(isShow) : false;
    }

    public boolean isShowField(String field) {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue(field, null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public Node getNodeView(Node node) throws Exception {
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        HashMap<String, Constant.SITE_MODE> context = new HashMap<String, Constant.SITE_MODE>();
        if (Utils.isLiveMode()) {
            context.put(Constant.RUNTIME_MODE, Constant.SITE_MODE.LIVE);
        } else {
            context.put(Constant.RUNTIME_MODE, Constant.SITE_MODE.EDITING);
        }
        String lifecyleName = publicationService.getNodeLifecycleName(node);
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecyleName);
        Node viewNode = publicationPlugin.getNodeView(node, context);
        return viewNode;
    }

    public boolean showDraftButton(Node node) throws Exception {
        String currentState = null;
        if (Utils.isLiveMode()) {
            return false;
        }
        try {
            currentState = node.getProperty("publication:currentState").getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PublicationState.DRAFT.equals(currentState);
    }

    public boolean showPaginator() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public DateFormat getDatetimeFommatter() {
        return this.dateFormatter;
    }

    public void setDateTimeFormat(String format) {
        ((SimpleDateFormat)this.dateFormatter).applyPattern(format);
    }

    public String getContentColumn() {
        return this.contentColumn;
    }

    public void setContentColumn(String column) {
        this.contentColumn = column;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPaginator;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public String getSummary(Node node) throws Exception {
        return node.hasProperty("exo:summary") ? node.getProperty("exo:summary").getValue().getString() : null;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String portalURI = portalRequestContext.getPortalURI();
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String repository = portletPreferences.getValue("repository", null);
        String workspace = portletPreferences.getValue("workspace", null);
        String baseURI = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        String parameterizedPageURI = wcmConfigurationService.getParameterizedPageURI();
        link = baseURI + portalURI + parameterizedPageURI.substring(1, parameterizedPageURI.length()) + "/" + repository + "/" + workspace + node.getPath();
        return link;
    }

    public String getAuthor(Node node) throws Exception {
        if (node.hasProperty("exo:owner")) {
            String ownerId = node.getProperty("exo:owner").getValue().getString();
            OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserProfileHandler handler = organizationService.getUserProfileHandler();
            UserProfile userProfile = handler.findUserProfileByName(ownerId);
            return (String)userProfile.getUserInfoMap().get("user.name.given");
        }
        return null;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getModifiedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            Calendar calendar = node.getProperty("exo:dateModified").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getContentType(Node node) {
        return null;
    }

    public String getContentIcon(Node node) {
        return null;
    }

    public String getContentSize(Node node) {
        return null;
    }

    public String getIllustrativeImage(Node node) throws Exception {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        Node illustrativeImage = null;
        RESTImagesRendererService imagesRendererService = (RESTImagesRendererService)this.getApplicationComponent(RESTImagesRendererService.class);
        String uri = null;
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = imagesRendererService.generateURI(illustrativeImage);
        }
        catch (Exception e) {
            // empty catch block
        }
        return uri;
    }

    public List<String> getCategories(Node node) {
        return null;
    }

    public List<String> getTags(Node node) {
        return null;
    }

    public float getVotingRate(Node node) {
        return 0.0f;
    }

    public int getNumberOfComments(Node node) {
        return 0;
    }

    public List<Node> getRelatedContents(Node node) {
        return null;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }
}

