/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.RefreshDelegateActionListener;
import org.exoplatform.wcm.webui.clv.UIContentListPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIListViewerBase
extends UIContainer
implements RefreshDelegateActionListener {
    protected boolean viewAbleContent = false;
    protected String messageKey;

    public abstract void init() throws Exception;

    public String getMessage() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return requestContext.getApplicationResourceBundle().getString(this.messageKey);
    }

    public boolean isViewAbleContent() {
        return this.viewAbleContent;
    }

    public void setViewAbleContent(boolean bool) {
        this.viewAbleContent = bool;
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (!Utils.isLiveMode() || context.getFullRender()) {
            this.init();
        }
        super.processRender(context);
    }

    protected PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    protected String getFormViewTemplatePath() {
        return this.getPortletPreference().getValue("formViewTemplatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = this.getPortletPreference().getValue("repository", null);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        String workspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public void onRefresh(Event<UIContentListPresentation> event) throws Exception {
        UIContentListPresentation contentListPresentation = (UIContentListPresentation)event.getSource();
        UIListViewerBase uiListViewerBase = (UIListViewerBase)contentListPresentation.getParent();
        uiListViewerBase.getChildren().clear();
        uiListViewerBase.init();
    }
}

