/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.io.Writer;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class)
public class UIPresentation
extends UIBaseNodePresentation {
    private JCRResourceResolver resourceResolver;
    private Node orginalNode = null;
    private Node viewNode = null;

    public Node getNode() throws Exception {
        return this.viewNode;
    }

    public void setViewNode(Node node) throws Exception {
        this.viewNode = node;
    }

    public String getRepositoryName() {
        return this.getRepository();
    }

    private PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    public String getRepository() {
        return this.getPortletPreference().getValue(UISingleContentViewerPortlet.REPOSITORY, "repository");
    }

    public Node getOriginalNode() throws Exception {
        return this.orginalNode;
    }

    public void setOriginalNode(Node node) throws Exception {
        this.orginalNode = node;
    }

    public String getTemplate() {
        try {
            return this.getTemplatePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        try {
            if (this.getTemplatePath() == null) {
                throw new NullPointerException();
            }
        }
        catch (ItemNotFoundException e) {
            Writer writer = context.getWriter();
            writer.write("<div style=\"padding-bottom: 20px; font-size: 13px; text-align: center; padding-top: 10px;\">");
            writer.write("<span>");
            writer.write(context.getApplicationResourceBundle().getString("UIMessageBoard.msg.content-not-found"));
            writer.write("</span>");
            writer.write("</div>");
            return;
        }
        catch (AccessDeniedException e) {
            Writer writer = context.getWriter();
            writer.write("<div class=\"Message\">");
            writer.write("<span>");
            writer.write(context.getApplicationResourceBundle().getString("UIMessageBoard.msg.no-permission"));
            writer.write("</span>");
            writer.write("</div>");
            return;
        }
        catch (RepositoryException e) {
            Writer writer = context.getWriter();
            writer.write("<div class=\"Message\">");
            writer.write("<span>");
            writer.write(context.getApplicationResourceBundle().getString("UIMessageBoard.msg.error-nodetype"));
            writer.write("</span>");
            writer.write("</div>");
            return;
        }
        catch (Exception e) {
            Writer writer = context.getWriter();
            writer.write("<div class=\"Message\">");
            writer.write("<span>");
            writer.write(context.getApplicationResourceBundle().getString("UIMessageBoard.msg.error-nodetype"));
            writer.write("</span>");
            writer.write("</div>");
            return;
        }
        UISingleContentViewerPortlet viewerPortlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        UIPopupContainer popupContainer = (UIPopupContainer)viewerPortlet.getChild(UIPopupContainer.class);
        if (popupContainer != null) {
            popupContainer.deActivate();
        }
        super.processRender(context);
    }

    public String getTemplatePath() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        if (this.viewNode != null) {
            return templateService.getTemplatePath(this.orginalNode, false);
        }
        return null;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        block3: {
            try {
                if (this.resourceResolver == null) {
                    RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                    String repository = this.getRepository();
                    ManageableRepository manageableRepository = repositoryService.getRepository(repository);
                    String workspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
                    this.resourceResolver = new JCRResourceResolver(repository, workspace, "exo:templateFile");
                }
            }
            catch (Exception e) {
                if (!UISingleContentViewerPortlet.scvLog.isDebugEnabled()) break block3;
                UISingleContentViewerPortlet.scvLog.debug((Object)e);
            }
        }
        return this.resourceResolver;
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public void setNode(Node node) {
    }
}

