/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.security.AccessControlException;
import java.util.HashMap;
import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.Constant;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.WebUIPropertiesConfigService;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.config.UIPortletConfig;
import org.exoplatform.wcm.webui.scv.config.UIStartEditionInPageWizard;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    public static final Log scvLog = ExoLogger.getLogger((String)"wcm:SingleContentViewer");
    private PortletMode mode_ = PortletMode.VIEW;

    public UISingleContentViewerPortlet() throws Exception {
        this.activateMode(this.mode_);
    }

    public void activateMode(PortletMode mode) throws Exception {
        this.getChildren().clear();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        if (portletRequestContext.getRemoteUser() != null) {
            this.addChild(UIPopupContainer.class, null, null);
        }
        if (PortletMode.VIEW.equals((Object)mode)) {
            this.addChild(UIPresentationContainer.class, null, UIPortletApplication.VIEW_MODE);
        } else if (PortletMode.EDIT.equals((Object)mode)) {
            UIPopupContainer maskPopupContainer = (UIPopupContainer)this.getChild(UIPopupContainer.class);
            UIStartEditionInPageWizard portletEditMode = (UIStartEditionInPageWizard)this.createUIComponent(UIStartEditionInPageWizard.class, null, null);
            this.addChild((UIComponent)portletEditMode);
            UIPortletConfig portletConfig = (UIPortletConfig)portletEditMode.createUIComponent(UIPortletConfig.class, null, null);
            portletEditMode.addChild((UIComponent)portletConfig);
            portletConfig.init();
            portletConfig.setRendered(true);
            WebUIPropertiesConfigService propertiesConfigService = (WebUIPropertiesConfigService)this.getApplicationComponent(WebUIPropertiesConfigService.class);
            WebUIPropertiesConfigService.PopupWindowProperties popupProperties = (WebUIPropertiesConfigService.PopupWindowProperties)propertiesConfigService.getProperties(WebUIPropertiesConfigService.SCV_POPUP_SIZE_EDIT_PORTLET_MODE);
            maskPopupContainer.activate((UIComponent)portletConfig, popupProperties.getWidth(), popupProperties.getHeight());
            portletRequestContext.addUIComponentToUpdateByAjax((UIComponent)maskPopupContainer);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (!this.mode_.equals((Object)newMode)) {
            this.activateMode(newMode);
            this.mode_ = newMode;
        }
        super.processRender(app, context);
    }

    public boolean canEditPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String userId = context.getRemoteUser();
        return Utils.canEditCurrentPortal((String)userId);
    }

    public Node getReferencedContent() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue(REPOSITORY, null);
        String workspace = preferences.getValue(WORKSPACE, null);
        String nodeIdentifier = preferences.getValue(IDENTIFIER, null);
        WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
        return wcmService.getReferencedContent(repository, workspace, nodeIdentifier);
    }

    private Node getLiveRevision(Node content) throws Exception {
        if (content == null) {
            return null;
        }
        HashMap<String, Constant.SITE_MODE> context = new HashMap<String, Constant.SITE_MODE>();
        context.put(Constant.RUNTIME_MODE, Constant.SITE_MODE.LIVE);
        PublicationService pubService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        String lifecycleName = pubService.getNodeLifecycleName(content);
        PublicationPlugin pubPlugin = (PublicationPlugin)pubService.getPublicationPlugins().get(lifecycleName);
        return pubPlugin.getNodeView(content, context);
    }

    private String getRevisionState(Node content) throws Exception {
        String currentState = null;
        try {
            currentState = content.getProperty("publication:currentState").getString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Constant.DRAFT_STATE.equals(currentState)) {
            return Constant.DRAFT_STATE;
        }
        if (Constant.ENROLLED_STATE.equals(currentState)) {
            String liveRevision = null;
            try {
                liveRevision = content.getProperty("publication:liveRevision").getString();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (liveRevision != null && liveRevision.length() > 0) {
                return Constant.LIVE_STATE;
            }
            return Constant.OBSOLETE_STATE;
        }
        return null;
    }

    public boolean canEditContent(Node content) throws Exception {
        if (content == null || !content.isNodeType("exo:webContent")) {
            return false;
        }
        try {
            ((ExtendedNode)content).checkPermission("add_node");
            ((ExtendedNode)content).checkPermission("remove");
            ((ExtendedNode)content).checkPermission("set_property");
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }
}

