/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.document;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.selector.document.UIDocumentTreeBuilder;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/wcm/webui/UIDocumentPathSelector.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="UIBreadcrumbDocumentPathSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class})}), @ComponentConfig(type=UISelectPathPanel.class, id="UIDocumentSelectPathPanel", template="classpath:groovy/wcm/webui/UIWCMSelectPathPanel.gtmpl", events={@EventConfig(listeners={UISelectPathPanel.SelectActionListener.class})})})
public class UIDocumentPathSelector
extends UIBaseNodeTreeSelector
implements UIPopupComponent {
    private Node currentPortal;
    private Node sharedPortal;
    private Node currentNode;

    public UIDocumentPathSelector() throws Exception {
        this.addChild(UIBreadcumbs.class, "UIBreadcrumbDocumentPathSelector", "UIBreadcrumbDocumentPathSelector");
        this.addChild(UIDocumentTreeBuilder.class, null, UIDocumentTreeBuilder.class.getSimpleName() + ((Object)((Object)this)).hashCode());
        this.addChild(UISelectPathPanel.class, "UIDocumentSelectPathPanel", "UIDocumentSelectPathPanel");
    }

    public void init() throws Exception {
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        String currentPortalName = Util.getUIPortal().getName();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        this.currentPortal = livePortalManagerService.getLivePortal(currentPortalName, sessionProvider);
        this.sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
        String repositoryName = ((ManageableRepository)this.currentPortal.getSession().getRepository()).getConfiguration().getName();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List acceptedNodeTypes = templateService.getDocumentTemplates(repositoryName);
        UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        String[] arrAcceptedNodeTypes = new String[acceptedNodeTypes.size()];
        acceptedNodeTypes.toArray(arrAcceptedNodeTypes);
        uiSelectPathPanel.setAcceptedNodeTypes(arrAcceptedNodeTypes);
        UIDocumentTreeBuilder treeBuilder = (UIDocumentTreeBuilder)this.getChild(UIDocumentTreeBuilder.class);
        treeBuilder.setCurrentPortal(this.currentPortal);
        treeBuilder.setSharedPortal(this.sharedPortal);
        treeBuilder.setRootTreeNode(this.currentPortal.getParent());
        sessionProvider.close();
    }

    public void onChange(Node node, Object context) throws Exception {
        UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        this.changeFolder(node);
        this.setCurrentNode(node);
        uiSelectPathPanel.setParentNode(node);
        uiSelectPathPanel.updateGrid();
    }

    private void changeFolder(Node selectedNode) throws Exception {
        UIBreadcumbs uiBreadcrumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        uiBreadcrumb.setPath(this.getPath(null, selectedNode));
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> list, Node selectedNode) throws Exception {
        if (list == null) {
            list = new ArrayList<UIBreadcumbs.LocalPath>(5);
        }
        if (selectedNode == null || selectedNode.getPath().equalsIgnoreCase(this.currentPortal.getParent().getPath()) || selectedNode.getPath().equals("/")) {
            return list;
        }
        list.add(0, new UIBreadcumbs.LocalPath(selectedNode.getPath(), selectedNode.getName()));
        this.getPath(list, selectedNode.getParent());
        return list;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getCurrentPortal() {
        return this.currentPortal;
    }

    public void setCurrentPortal(Node currentPortal) {
        this.currentPortal = currentPortal;
    }

    public Node getSharedPortal() {
        return this.sharedPortal;
    }

    public void setSharedPortal(Node sharedPortal) {
        this.sharedPortal = sharedPortal;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            String selectedNodePath = event.getRequestContext().getRequestParameter("objectId");
            UIDocumentPathSelector uiDocumentPathSelector = (UIDocumentPathSelector)uiBreadcumbs.getAncestorOfType(UIDocumentPathSelector.class);
            Node currentPortal = uiDocumentPathSelector.getCurrentPortal();
            Node sharedPortal = uiDocumentPathSelector.getSharedPortal();
            if (selectedNodePath.equals(currentPortal.getPath()) || selectedNodePath.equals(sharedPortal.getPath())) {
                selectedNodePath = currentPortal.getParent().getPath();
            }
            UIDocumentTreeBuilder uiDocumentTreeBuilder = (UIDocumentTreeBuilder)uiDocumentPathSelector.getChild(UIDocumentTreeBuilder.class);
            uiDocumentTreeBuilder.changeNode(selectedNodePath, event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentPathSelector);
        }
    }
}

