/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.wcm.webui.search.UISearchForm;
import org.exoplatform.wcm.webui.search.UISearchPageLayout;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UISearchResult
extends UIContainer {
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String keyword;
    private String resultType;
    private String suggestion;
    private String suggestionURL;
    private String pageMode;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private float searchTime;
    private List<ResultNode> moreListResult;
    private Set<Integer> morePageSet;
    public static final String PARAMETER_REGX = "(portal=.*)&(keyword=.*)";
    public static final String RESULT_NOT_FOUND = "UISearchResult.msg.result-not-found";

    public void init(String templatePath, ResourceResolver resourceResolver) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        String paginatorTemplatePath = portletPreferences.getValue("searchPaginatorTemplatePath", null);
        this.pageMode = portletPreferences.getValue("pageMode", "none");
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageMode(this.pageMode);
        this.clearResult();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        PortletPreferences portletPreferences = porletRequestContext.getRequest().getPreferences();
        if (this.resultType == null || this.resultType.trim().length() == 0) {
            this.resultType = "Document";
        }
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String portal = portalRequestContext.getRequestParameter("portal");
        String keyword = portalRequestContext.getRequestParameter("keyword");
        if (portal != null && keyword != null && keyword.length() > 0) {
            UISearchPageLayout uiSearchPageContainer = (UISearchPageLayout)this.getAncestorOfType(UISearchPageLayout.class);
            UISearchForm searchForm = (UISearchForm)uiSearchPageContainer.getChild(UISearchForm.class);
            searchForm.getUIStringInput("keywordInput").setValue((Object)keyword);
            if (searchForm.getUIFormSelectBox("portalSelector").getValue() != null) {
                portal = (String)searchForm.getUIFormSelectBox("portalSelector").getValue();
            }
            if (searchForm.getUIStringInput("keywordInput").getValue() != null) {
                keyword = (String)searchForm.getUIStringInput("keywordInput").getValue();
            }
            this.setKeyword(keyword);
            keyword = Normalizer.normalize(keyword, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
            keyword = keyword.replaceAll("'", "''");
            SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
            QueryCriteria queryCriteria = new QueryCriteria();
            UIFormRadioBoxInput searchOption = searchForm.getUIFormRadioBoxInput("searchOption");
            boolean isSearchDocument = ((String)searchOption.getValue()).equals("documentCheckBox");
            boolean isWebPage = ((String)searchOption.getValue()).equals("pageCheckBox");
            List documentNodeTypes = new ArrayList<String>();
            if (isSearchDocument) {
                TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
                documentNodeTypes = templateService.getAllDocumentNodeTypes();
                portal = Util.getPortalRequestContext().getPortalOwner();
                this.resultType = "Document";
            } else {
                documentNodeTypes.add("gtn:language");
                documentNodeTypes.add("exo:pageMetadata");
                queryCriteria.setFulltextSearchProperty(new String[]{"exo:metaKeywords", "exo:metaDescription", "gtn:name"});
                this.resultType = "Page";
            }
            String pageMode = portletPreferences.getValue("pageMode", "none");
            queryCriteria.setContentTypes(documentNodeTypes.toArray(new String[documentNodeTypes.size()]));
            queryCriteria.setSiteName(portal);
            queryCriteria.setKeyword(org.exoplatform.services.cms.impl.Utils.escapeIllegalCharacterInQuery((String)keyword).toLowerCase());
            queryCriteria.setSearchWebpage(isWebPage);
            queryCriteria.setSearchDocument(isSearchDocument);
            queryCriteria.setSearchWebContent(isSearchDocument);
            queryCriteria.setPageMode(pageMode);
            queryCriteria.setLiveMode("Live".equals(Utils.getCurrentMode()));
            int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
            try {
                AbstractPageList pageList = null;
                pageList = isWebPage ? siteSearchService.searchPageContents(WCMCoreUtils.getSystemSessionProvider(), queryCriteria, itemsPerPage, false) : siteSearchService.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), queryCriteria, itemsPerPage, false);
                this.setSearchTime((float)(pageList.getQueryTime() / 1000L));
                this.setSuggestion(pageList.getSpellSuggestion());
                if (pageList.getAvailable() <= 0) {
                    String suggestion = pageList.getSpellSuggestion();
                    this.setSuggestionURL(suggestion);
                    searchForm.setSubmitAction(suggestion);
                }
                this.setPageList((PageList)pageList);
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UISearchForm.message.keyword-not-support", null, 1));
            }
        }
        super.processRender(context);
    }

    public void setPageList(PageList dataPageList) {
        this.uiPaginator.setPageList(dataPageList);
        this.moreListResult = new ArrayList();
        this.morePageSet = new HashSet();
    }

    public int getTotalItem() {
        return this.uiPaginator.getPageList().getAvailable();
    }

    public int getItemsPerPage() {
        return this.uiPaginator.getPageList().getPageSize();
    }

    public int getCurrentPage() {
        return this.uiPaginator.getCurrentPage();
    }

    public String getPageMode() {
        return this.pageMode;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        if (node.hasProperty("exo:title")) {
            return node.getProperty("exo:title").getValue().getString();
        }
        Session session = node.getSession();
        Node mopLink = (Node)session.getItem(node.getPath() + "/mop:link");
        if (mopLink != null && mopLink.hasProperty("mop:page")) {
            String mopPageLink = mopLink.getProperty("mop:page").getValue().getString();
            Node mopPage = (Node)session.getItem(mopPageLink);
            if (mopPage != null && mopPage.hasProperty("gtn:name")) {
                return mopPage.getProperty("gtn:name").getValue().getString();
            }
            return node.getName().replaceFirst("mop:", "");
        }
        return node.getName().replaceFirst("mop:", "");
    }

    public List<String> getURLs(Node node) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        if (!node.hasProperty("publication:navigationNodeURIs")) {
            urls.add(this.getURL(node));
        } else {
            for (Value value : node.getProperty("publication:navigationNodeURIs").getValues()) {
                urls.add(value.getString());
            }
        }
        return urls;
    }

    public String getPublishedNodeURI(String navNodeURI) {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        PortletRequest portletRequest = this.getPortletRequest();
        StringBuffer baseURI = new StringBuffer();
        baseURI.append(portletRequest.getScheme()).append("://").append(portletRequest.getServerName());
        if (portletRequest.getServerPort() != 80) {
            baseURI.append(":").append(String.format("%s", portletRequest.getServerPort()));
        }
        if (navNodeURI.startsWith(baseURI.toString())) {
            return navNodeURI;
        }
        NodeURL nodeURL = (NodeURL)portalRequestContext.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(portalRequestContext.getSiteType(), portalRequestContext.getSiteName(), navNodeURI);
        nodeURL.setResource(resource);
        return baseURI + nodeURL.toString();
    }

    public String getURL(Node node) throws Exception {
        PortletRequest portletRequest = this.getPortletRequest();
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String repository = WCMCoreUtils.getRepository().getConfiguration().getName();
        String workspace = portletPreferences.getValue("workspace", null);
        String basePath = portletPreferences.getValue("basePath", null);
        String detailParameterName = portletPreferences.getValue("detailParameterName", null);
        StringBuffer path = new StringBuffer();
        path.append("/").append(repository).append("/").append(workspace);
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), basePath);
        nodeURL.setResource(resource);
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            path.append(originalNode.getPath());
            nodeURL.setQueryParameterValue("version", node.getParent().getName());
        } else {
            path.append(node.getPath());
        }
        nodeURL.setQueryParameterValue(detailParameterName, path.toString());
        nodeURL.setSchemeUse(true);
        return nodeURL.toString();
    }

    private PortletRequest getPortletRequest() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest();
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public boolean isShowPaginator() throws Exception {
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public float getSearchTime() {
        return this.searchTime;
    }

    public void setSearchTime(float searchTime) {
        this.searchTime = searchTime;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getSuggestionURL() {
        return this.suggestionURL;
    }

    public void setSuggestionURL(String suggestionURL) {
        this.suggestionURL = suggestionURL;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public int getNumberOfPage() {
        return this.uiPaginator.getPageList().getAvailablePage();
    }

    public void clearResult() {
        this.moreListResult = new ArrayList();
        this.morePageSet = new HashSet();
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        this.setPageList((PageList)new ObjectPageList(new ArrayList(), Integer.parseInt(itemsPerPage)));
    }

    public List<ResultNode> getRealCurrentPageData() throws Exception {
        int currentPage = this.getCurrentPage();
        if ("more".equals(this.pageMode) && !this.morePageSet.contains(currentPage)) {
            this.morePageSet.add(currentPage);
            this.moreListResult.addAll(this.getCurrentPageData());
        }
        return "more".equals(this.pageMode) ? this.moreListResult : this.getCurrentPageData();
    }
}

