/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.wcm.webui.search.UISearchForm;
import org.exoplatform.wcm.webui.search.UISearchPageLayout;
import org.exoplatform.wcm.webui.search.UISearchResult;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UISearchPageLayout
extends UIContainer {
    public static final String SEARCH_FORM = "uiSearchForm";
    public static final String SEARCH_RESULT = "uiSearchResult";

    public UISearchPageLayout() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UISearchForm uiSearchForm = (UISearchForm)this.addChild(UISearchForm.class, null, null);
        UISearchResult uiSearchResult = (UISearchResult)this.addChild(UISearchResult.class, null, null);
        String searchFormTemplatePath = this.getTemplatePath("searchFormTemplatePath");
        uiSearchForm.init(searchFormTemplatePath, this.getTemplateResourceResolver(context, searchFormTemplatePath));
        String searchResultTemplatePath = this.getTemplatePath("searchResultTemplatePath");
        uiSearchResult.init(searchResultTemplatePath, this.getTemplateResourceResolver(context, searchResultTemplatePath));
    }

    private PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    private String getTemplatePath(String templateType) {
        return this.getPortletPreference().getValue(templateType, null);
    }

    public String getTemplate() {
        String template = this.getPortletPreference().getValue("searchPageLayoutTemplatePath", null);
        return template;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
            return new JCRResourceResolver(workspace);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }
}

