/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.wcm.webui.search.UISearchForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormHiddenInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SearchActionListener.class})})
public class UISearchForm
extends UIForm {
    private String templatePath;
    private ResourceResolver resourceResolver;
    public static final String KEYWORD_INPUT = "keywordInput";
    public static final String SEARCH_OPTION = "searchOption";
    public static final String DOCUMENT_CHECKING = "documentCheckBox";
    public static final String PAGE_CHECKING = "pageCheckBox";
    public static final String PORTALS_SELECTOR = "portalSelector";
    public static final String ALL_OPTION = "all";
    public static final String SORT_FIELD_HIDDEN_INPUT = "sortHiddenInputField";
    public static final String ORDER_TYPE_HIDDEN_INPUT = "orderTypeHiddenInputField";
    public static final String MESSAGE_NOT_CHECKED_TYPE_SEARCH = "UISearchForm.message.not-checked";
    public static final String MESSAGE_NOT_SUPPORT_KEYWORD = "UISearchForm.message.keyword-not-support";
    public static final String MESSAGE_NOT_EMPTY_KEYWORD = "UISearchForm.message.keyword-not-empty";

    public UISearchForm() throws Exception {
        UIFormStringInput uiKeywordInput = new UIFormStringInput(KEYWORD_INPUT, KEYWORD_INPUT, null);
        UIFormSelectBox uiPortalSelectBox = new UIFormSelectBox(PORTALS_SELECTOR, PORTALS_SELECTOR, this.getPortalList());
        ArrayList<SelectItemOption> searchOptionList = new ArrayList<SelectItemOption>();
        SelectItemOption pageOption = new SelectItemOption(PAGE_CHECKING, (Object)PAGE_CHECKING);
        SelectItemOption docOption = new SelectItemOption(DOCUMENT_CHECKING, (Object)DOCUMENT_CHECKING);
        searchOptionList.add(docOption);
        searchOptionList.add(pageOption);
        UIFormRadioBoxInput searchOptionRadioBox = new UIFormRadioBoxInput(SEARCH_OPTION, SEARCH_OPTION, searchOptionList);
        searchOptionRadioBox.setDefaultValue((Object)DOCUMENT_CHECKING);
        searchOptionRadioBox.setValue((Object)DOCUMENT_CHECKING);
        this.addUIFormInput((UIFormInput)uiKeywordInput);
        this.addUIFormInput((UIFormInput)uiPortalSelectBox);
        this.addUIFormInput((UIFormInput)searchOptionRadioBox);
        this.addUIFormInput((UIFormInput)new UIFormHiddenInput(SORT_FIELD_HIDDEN_INPUT, SORT_FIELD_HIDDEN_INPUT, null));
        this.addUIFormInput((UIFormInput)new UIFormHiddenInput(ORDER_TYPE_HIDDEN_INPUT, ORDER_TYPE_HIDDEN_INPUT, null));
    }

    public void init(String templatePath, ResourceResolver resourceResolver) {
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public void setKeyword() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String keyword = portalRequestContext.getRequestParameter("keyword");
        if (keyword != null && keyword.length() > 0) {
            this.getUIStringInput(KEYWORD_INPUT).setValue((Object)keyword);
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    private List getPortalList() throws Exception {
        ArrayList<SelectItemOption> portals = new ArrayList<SelectItemOption>();
        DataStorage service = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        List list = service.find(query).getAll();
        portals.add(new SelectItemOption(ALL_OPTION, (Object)ALL_OPTION));
        for (PortalConfig portalConfig : list) {
            portals.add(new SelectItemOption(portalConfig.getName(), (Object)portalConfig.getName()));
        }
        return portals;
    }

    public UIFormRadioBoxInput getUIFormRadioBoxInput(String name) {
        return (UIFormRadioBoxInput)this.findComponentById(name);
    }
}

